/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssertStatement;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyGeneratorExpression;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public class TypeAssertionIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.insert.assertion", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/TypeAssertionIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.insert.assertion", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/TypeAssertionIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/TypeAssertionIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PsiElement elementAt = PyUtil.findNonWhitespaceAtOffset(file, editor.getCaretModel().getOffset());
        PyExpression problemElement = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyReferenceExpression.class);
        if (problemElement == null) {
            return false;
        }
        if (problemElement.getParent() instanceof PyWithItem) {
            return false;
        }
        PyExpression qualifier = ((PyQualifiedExpression)problemElement).getQualifier();
        if (qualifier != null && !qualifier.getText().equals("self")) {
            problemElement = qualifier;
        }
        PsiReference reference = problemElement.getReference();
        if (problemElement.getParent() instanceof PyCallExpression || PsiTreeUtil.getParentOfType((PsiElement)problemElement, PyComprehensionElement.class) != null || PsiTreeUtil.getParentOfType((PsiElement)problemElement, PyLambdaExpression.class) != null || PsiTreeUtil.getParentOfType((PsiElement)problemElement, PyGeneratorExpression.class) != null || reference != null && reference.resolve() == null) {
            return false;
        }
        PyType type = TypeEvalContext.codeAnalysis(file.getProject(), file).getType(problemElement);
        return type == null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/TypeAssertionIntention", "invoke"));
        }
        PsiElement elementAt = PyUtil.findNonWhitespaceAtOffset(file, editor.getCaretModel().getOffset());
        PyExpression problemElement = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyReferenceExpression.class);
        if (problemElement != null) {
            Object element;
            String referencedName;
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            String name = problemElement.getText();
            PyExpression qualifier = ((PyQualifiedExpression)problemElement).getQualifier();
            if (qualifier != null && !qualifier.getText().equals("self") && ((referencedName = ((PyQualifiedExpression)problemElement).getReferencedName()) == null || "__getitem__".equals(referencedName))) {
                name = qualifier.getText();
            }
            String text = "assert isinstance(" + name + ", )";
            PyAssertStatement assertStatement = elementGenerator.createFromText(LanguageLevel.forElement((PsiElement)problemElement), PyAssertStatement.class, text);
            PsiElement parentStatement = PsiTreeUtil.getParentOfType((PsiElement)problemElement, PyStatement.class);
            if (parentStatement == null) {
                return;
            }
            PsiElement parent = parentStatement.getParent();
            if (parentStatement instanceof PyAssignmentStatement && ((PyAssignmentStatement)parentStatement).getTargets()[0] == problemElement) {
                element = parent.addAfter((PsiElement)assertStatement, parentStatement);
            } else {
                PyStatementList statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)parentStatement, PyStatementList.class);
                Document document = editor.getDocument();
                if (statementList != null) {
                    PsiElement statementListParent = PsiTreeUtil.getParentOfType((PsiElement)statementList, PyStatement.class);
                    if (statementListParent != null && document.getLineNumber(statementList.getTextOffset()) == document.getLineNumber(statementListParent.getTextOffset())) {
                        String substring = TextRange.create((int)statementListParent.getTextRange().getStartOffset(), (int)statementList.getTextOffset()).substring(document.getText());
                        PyStatement foo = elementGenerator.createFromText(LanguageLevel.forElement((PsiElement)problemElement), PyStatement.class, substring + "\n\t" + text + "\n\t" + statementList.getText());
                        statementListParent = statementListParent.replace((PsiElement)foo);
                        statementList = (PyStatementList)PsiTreeUtil.findChildOfType((PsiElement)statementListParent, PyStatementList.class);
                        assert (statementList != null);
                        element = statementList.getStatements()[0];
                    } else {
                        element = parent.addBefore((PsiElement)assertStatement, parentStatement);
                    }
                } else {
                    element = parent.addBefore((PsiElement)assertStatement, parentStatement);
                }
            }
            int textOffSet = element.getTextOffset();
            editor.getCaretModel().moveToOffset(textOffSet);
            element = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(element);
            TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder(element);
            builder.replaceRange(TextRange.create((int)(text.length() - 1), (int)(text.length() - 1)), "object");
            Template template = ((TemplateBuilderImpl)builder).buildInlineTemplate();
            TemplateManager.getInstance(project).startTemplate(editor, template);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

