/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.intentions.TypeIntention;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;

public class SpecifyTypeInPy3AnnotationsIntention
extends TypeIntention {
    private String myText = PyBundle.message("INTN.specify.type.in.annotation", new Object[0]);

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInPy3AnnotationsIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.specify.type.in.annotation", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInPy3AnnotationsIntention", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInPy3AnnotationsIntention", "isAvailable"));
        }
        if (!LanguageLevel.forElement((PsiElement)file).isPy3K()) {
            return false;
        }
        return super.isAvailable(project, editor, file);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PyExpression problemElement;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInPy3AnnotationsIntention", "invoke"));
        }
        PsiElement elementAt = PyUtil.findNonWhitespaceAtOffset(file, editor.getCaretModel().getOffset());
        PsiReference reference = (problemElement = SpecifyTypeInPy3AnnotationsIntention.getProblemElement(elementAt)) == null ? null : problemElement.getReference();
        PsiElement resolved = reference != null ? reference.resolve() : null;
        PyParameter parameter = SpecifyTypeInPy3AnnotationsIntention.getParameter(problemElement, resolved);
        if (parameter != null) {
            SpecifyTypeInPy3AnnotationsIntention.annotateParameter(project, editor, parameter);
        } else {
            this.annotateReturnType(project, elementAt);
        }
    }

    private static void annotateParameter(Project project, Editor editor, PyParameter parameter) {
        PyAnnotation annotation;
        PyExpression defaultParamValue = parameter instanceof PyNamedParameter ? parameter.getDefaultValue() : null;
        String name = StringUtil.notNullize((String)parameter.getName());
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        String defaultParamText = defaultParamValue == null ? null : defaultParamValue.getText();
        PyNamedParameter namedParameter = elementGenerator.createParameter(name, defaultParamText, "object", LanguageLevel.forElement((PsiElement)parameter));
        assert (namedParameter != null);
        parameter = (PyParameter)parameter.replace((PsiElement)namedParameter);
        parameter = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(parameter);
        editor.getCaretModel().moveToOffset(parameter.getTextOffset());
        PyAnnotation pyAnnotation = annotation = parameter instanceof PyNamedParameter ? ((PyNamedParameter)parameter).getAnnotation() : null;
        if (annotation != null) {
            PyExpression annotationValue = annotation.getValue();
            TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)parameter);
            int replacementStart = annotation.getStartOffsetInParent() + annotationValue.getStartOffsetInParent();
            builder.replaceRange(TextRange.create((int)replacementStart, (int)(replacementStart + annotationValue.getTextLength())), "object");
            Template template = ((TemplateBuilderImpl)builder).buildInlineTemplate();
            TemplateManager.getInstance(project).startTemplate(editor, template);
        }
    }

    private void annotateReturnType(Project project, PsiElement resolved) {
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        Callable callable = this.getCallable(resolved);
        if (callable instanceof PyFunction) {
            String functionSignature = "def " + callable.getName() + callable.getParameterList().getText();
            String functionText = functionSignature + " -> object:";
            PyStatementList statementList = ((PyFunction)callable).getStatementList();
            assert (statementList != null);
            for (PyStatement st : statementList.getStatements()) {
                functionText = functionText + "\n\t" + st.getText();
            }
            PyFunction function = elementGenerator.createFromText(LanguageLevel.forElement((PsiElement)callable), PyFunction.class, functionText);
            callable = (PyFunction)callable.replace(function);
            callable = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(callable);
            PyAnnotation annotation = ((PyFunction)callable).getAnnotation();
            assert (annotation != null);
            PyExpression annotationValue = annotation.getValue();
            int offset = annotationValue.getTextOffset();
            TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)annotationValue);
            builder.replaceRange(TextRange.create((int)0, (int)"object".length()), "object");
            Template template = ((TemplateBuilderImpl)builder).buildInlineTemplate();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, callable.getContainingFile().getVirtualFile(), offset);
            Editor targetEditor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
            if (targetEditor != null) {
                targetEditor.getCaretModel().moveToOffset(offset);
                TemplateManager.getInstance(project).startTemplate(targetEditor, template);
            }
        }
    }

    @Override
    protected boolean isParamTypeDefined(PyParameter parameter) {
        return this.isDefinedInAnnotation(parameter);
    }

    private boolean isDefinedInAnnotation(PyParameter parameter) {
        if (LanguageLevel.forElement((PsiElement)parameter).isOlderThan(LanguageLevel.PYTHON30)) {
            return false;
        }
        return parameter instanceof PyNamedParameter && ((PyNamedParameter)parameter).getAnnotation() != null;
    }

    @Override
    protected boolean isReturnTypeDefined(@NotNull PyFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInPy3AnnotationsIntention", "isReturnTypeDefined"));
        }
        return function.getAnnotation() != null;
    }

    @Override
    protected void updateText(boolean isReturn) {
        this.myText = isReturn ? PyBundle.message("INTN.specify.return.type.in.annotation", new Object[0]) : PyBundle.message("INTN.specify.type.in.annotation", new Object[0]);
    }
}

