/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.intentions.TypeIntention;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.documentation.PyDocstringGenerator;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import org.jetbrains.annotations.NotNull;

public class SpecifyTypeInDocstringIntention
extends TypeIntention {
    private String myText = PyBundle.message("INTN.specify.type", new Object[0]);

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInDocstringIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.specify.type", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInDocstringIntention", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInDocstringIntention", "invoke"));
        }
        PsiElement elementAt = PyUtil.findNonWhitespaceAtOffset(file, editor.getCaretModel().getOffset());
        PyExpression problemElement = SpecifyTypeInDocstringIntention.getProblemElement(elementAt);
        PsiReference reference = problemElement == null ? null : problemElement.getReference();
        PsiElement resolved = reference != null ? reference.resolve() : null;
        PyParameter parameter = SpecifyTypeInDocstringIntention.getParameter(problemElement, resolved);
        String kind = parameter != null ? "type" : "rtype";
        Callable callable = parameter != null ? (Callable)PsiTreeUtil.getParentOfType((PsiElement)parameter, PyFunction.class) : this.getCallable(elementAt);
        if (callable instanceof PyFunction) {
            SpecifyTypeInDocstringIntention.generateDocstring(kind, (PyFunction)callable, problemElement, editor);
        }
    }

    private static void generateDocstring(String kind, PyFunction pyFunction, PyExpression problemElement, Editor editor) {
        String name = "rtype".equals(kind) ? "" : StringUtil.notNullize((String)problemElement.getName());
        PyDocstringGenerator docstringGenerator = new PyDocstringGenerator(pyFunction);
        PySignature signature = PySignatureCacheManager.getInstance(pyFunction.getProject()).findSignature(pyFunction);
        if (signature != null) {
            docstringGenerator.withParamTypedByQualifiedName(kind, name, signature.getArgTypeQualifiedName(name), pyFunction);
        } else {
            docstringGenerator.withParam(kind, name);
        }
        Module module = ModuleManager.getInstance((Project)pyFunction.getProject()).getModules()[0];
        PyDocumentationSettings documentationSettings = PyDocumentationSettings.getInstance(module);
        if (documentationSettings.isPlain(pyFunction.getContainingFile())) {
            String[] values = new String[]{"Epytext", "reStructuredText"};
            int i = Messages.showChooseDialog((String)"Docstring format:", (String)"Select Docstring Type", (String[])values, (String)"Epytext", null);
            if (i < 0) {
                return;
            }
            String value = values[i];
            documentationSettings.setFormat(value);
        }
        docstringGenerator.build();
        docstringGenerator.startTemplate();
    }

    @Override
    protected void updateText(boolean isReturn) {
        this.myText = isReturn ? PyBundle.message("INTN.specify.return.type", new Object[0]) : PyBundle.message("INTN.specify.type", new Object[0]);
    }

    @Override
    protected boolean isParamTypeDefined(@NotNull PyParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInDocstringIntention", "isParamTypeDefined"));
        }
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)parameter, PyFunction.class);
        if (pyFunction != null) {
            StructuredDocString structuredDocString = pyFunction.getStructuredDocString();
            return structuredDocString != null && structuredDocString.getParamType(StringUtil.notNullize((String)parameter.getName())) != null;
        }
        return false;
    }

    @Override
    protected boolean isReturnTypeDefined(@NotNull PyFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInDocstringIntention", "isReturnTypeDefined"));
        }
        StructuredDocString structuredDocString = function.getStructuredDocString();
        return structuredDocString != null && structuredDocString.getReturnType() != null;
    }
}

