/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.ComprehensionComponent;
import com.jetbrains.python.psi.ComprhForComponent;
import com.jetbrains.python.psi.ComprhIfComponent;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyPrintStatement;
import com.jetbrains.python.psi.impl.PyStatementListImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ReplaceListComprehensionWithForIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.replace.list.comprehensions.with.for", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/ReplaceListComprehensionWithForIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.replace.list.comprehensions.with.for", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/ReplaceListComprehensionWithForIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/ReplaceListComprehensionWithForIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyListCompExpression expression = (PyListCompExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyListCompExpression.class);
        if (expression == null) {
            return false;
        }
        if (expression.getComponents().isEmpty()) {
            return false;
        }
        PsiElement parent = expression.getParent();
        return parent instanceof PyAssignmentStatement || parent instanceof PyPrintStatement;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/ReplaceListComprehensionWithForIntention", "invoke"));
        }
        PyListCompExpression expression = (PyListCompExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyListCompExpression.class);
        if (expression == null) {
            return;
        }
        PsiElement parent = expression.getParent();
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        if (parent instanceof PyAssignmentStatement) {
            PyExpression leftExpr = ((PyAssignmentStatement)parent).getLeftHandSideExpression();
            if (leftExpr == null) {
                return;
            }
            PyAssignmentStatement initAssignment = elementGenerator.createFromText(LanguageLevel.forElement(expression), PyAssignmentStatement.class, leftExpr.getText() + " = []");
            PyForStatement forStatement = ReplaceListComprehensionWithForIntention.createForLoop(expression, elementGenerator, leftExpr.getText() + ".append(" + expression.getResultExpression().getText() + ")");
            PyStatementListImpl stList = new PyStatementListImpl(initAssignment.getNode());
            stList.add(initAssignment);
            stList.add(forStatement);
            stList.getStatements()[0].delete();
            parent.replace((PsiElement)stList);
        } else if (parent instanceof PyPrintStatement) {
            PyForStatement forStatement = ReplaceListComprehensionWithForIntention.createForLoop(expression, elementGenerator, "print (" + expression.getResultExpression().getText() + ")");
            parent.replace((PsiElement)forStatement);
        }
    }

    private static PyForStatement createForLoop(PyListCompExpression expression, PyElementGenerator elementGenerator, String result) {
        List<ComprehensionComponent> components = expression.getComponents();
        StringBuilder stringBuilder = new StringBuilder();
        int slashNum = 1;
        for (ComprehensionComponent component : components) {
            PyExpression test;
            if (component instanceof ComprhForComponent) {
                stringBuilder.append("for ");
                stringBuilder.append(((ComprhForComponent)component).getIteratorVariable().getText());
                stringBuilder.append(" in ");
                stringBuilder.append(((ComprhForComponent)component).getIteratedList().getText());
                stringBuilder.append(":\n");
            }
            if (component instanceof ComprhIfComponent && (test = ((ComprhIfComponent)component).getTest()) != null) {
                stringBuilder.append("if ");
                stringBuilder.append(test.getText());
                stringBuilder.append(":\n");
            }
            for (int i = 0; i != slashNum; ++i) {
                stringBuilder.append("\t");
            }
            ++slashNum;
        }
        stringBuilder.append(result);
        return elementGenerator.createFromText(LanguageLevel.forElement(expression), PyForStatement.class, stringBuilder.toString());
    }

    public boolean startInWriteAction() {
        return true;
    }
}

