/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyYieldExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyYieldFromIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.yield.from", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyYieldFromIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.yield.from", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyYieldFromIntention", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PyForStatement forLoop;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyYieldFromIntention", "isAvailable"));
        }
        if (LanguageLevel.forElement((PsiElement)file).isAtLeast(LanguageLevel.PYTHON33) && (forLoop = PyYieldFromIntention.findForStatementAtCaret(editor, file)) != null) {
            String targetName;
            PyTargetExpression forTarget = PyYieldFromIntention.findSingleForLoopTarget(forLoop);
            PyReferenceExpression yieldValue = PyYieldFromIntention.findSingleYieldValue(forLoop);
            if (forTarget != null && yieldValue != null && (targetName = forTarget.getName()) != null && targetName.equals(yieldValue.getName())) {
                return true;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PyExpression source;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyYieldFromIntention", "invoke"));
        }
        PyForStatement forLoop = PyYieldFromIntention.findForStatementAtCaret(editor, file);
        if (forLoop != null && (source = forLoop.getForPart().getSource()) != null) {
            PyExpression yieldValue;
            PyElementGenerator generator = PyElementGenerator.getInstance(project);
            String text = "yield from foo";
            PyExpressionStatement exprStmt = generator.createFromText(LanguageLevel.forElement((PsiElement)file), PyExpressionStatement.class, "yield from foo");
            PyExpression expr = exprStmt.getExpression();
            if (expr instanceof PyYieldExpression && (yieldValue = ((PyYieldExpression)expr).getExpression()) != null) {
                yieldValue.replace((PsiElement)source);
                forLoop.replace((PsiElement)exprStmt);
            }
        }
    }

    @Nullable
    private static PyForStatement findForStatementAtCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/intentions/PyYieldFromIntention", "findForStatementAtCaret"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/intentions/PyYieldFromIntention", "findForStatementAtCaret"));
        }
        PsiElement elementAtCaret = file.findElementAt(editor.getCaretModel().getOffset());
        return (PyForStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, PyForStatement.class);
    }

    @Nullable
    private static PyTargetExpression findSingleForLoopTarget(@NotNull PyForStatement forLoop) {
        if (forLoop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forLoop", "com/jetbrains/python/codeInsight/intentions/PyYieldFromIntention", "findSingleForLoopTarget"));
        }
        PyForPart forPart = forLoop.getForPart();
        PyExpression forTarget = forPart.getTarget();
        if (forTarget instanceof PyTargetExpression) {
            return (PyTargetExpression)forTarget;
        }
        return null;
    }

    @Nullable
    private static PyReferenceExpression findSingleYieldValue(@NotNull PyForStatement forLoop) {
        PyYieldExpression yieldExpr;
        PyExpression yieldValue;
        PyExpression firstExpr;
        PyStatement firstStmt;
        PyStatement[] statements;
        if (forLoop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forLoop", "com/jetbrains/python/codeInsight/intentions/PyYieldFromIntention", "findSingleYieldValue"));
        }
        PyForPart forPart = forLoop.getForPart();
        PyStatementList stmtList = forPart.getStatementList();
        if (stmtList != null && forLoop.getElsePart() == null && (statements = stmtList.getStatements()).length == 1 && (firstStmt = statements[0]) instanceof PyExpressionStatement && (firstExpr = ((PyExpressionStatement)firstStmt).getExpression()) instanceof PyYieldExpression && (yieldValue = (yieldExpr = (PyYieldExpression)firstExpr).getExpression()) instanceof PyReferenceExpression) {
            return (PyReferenceExpression)yieldValue;
        }
        return null;
    }
}

