/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyIfStatement;
import org.jetbrains.annotations.NotNull;

public class PyTransformConditionalExpressionIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.transform.into.if.else.statement", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyTransformConditionalExpressionIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.transform.into.if.else.statement", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyTransformConditionalExpressionIntention", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyTransformConditionalExpressionIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyAssignmentStatement expression = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyAssignmentStatement.class);
        return expression != null && expression.getAssignedValue() instanceof PyConditionalExpression;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyTransformConditionalExpressionIntention", "invoke"));
        }
        PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyAssignmentStatement.class);
        assert (assignmentStatement != null);
        PyExpression assignedValue = assignmentStatement.getAssignedValue();
        if (assignedValue instanceof PyConditionalExpression) {
            PyConditionalExpression expression = (PyConditionalExpression)assignedValue;
            PyExpression condition = expression.getCondition();
            PyExpression falsePart = expression.getFalsePart();
            if (condition != null && falsePart != null) {
                String truePartText = expression.getTruePart().getText();
                PyExpression leftHandSideExpression = assignmentStatement.getLeftHandSideExpression();
                if (leftHandSideExpression != null) {
                    String targetText = leftHandSideExpression.getText();
                    PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
                    String text = "if " + condition.getText() + ":\n\t" + targetText + " = " + truePartText + "\nelse:\n\t" + targetText + " = " + falsePart.getText();
                    PyIfStatement ifStatement = elementGenerator.createFromText(LanguageLevel.forElement((PsiElement)expression), PyIfStatement.class, text);
                    assignmentStatement.replace((PsiElement)ifStatement);
                }
            }
        }
    }
}

