/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PyStringConcatenationToFormatIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.string.concatenation.to.format", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyStringConcatenationToFormatIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyStringConcatenationToFormatIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyBinaryExpression.class, (boolean)false);
        if (element == null) {
            return false;
        }
        while (element.getParent() instanceof PyBinaryExpression) {
            element = element.getParent();
        }
        Collection<PyElementType> operators = PyStringConcatenationToFormatIntention.getOperators((PyBinaryExpression)element);
        for (PyElementType operator : operators) {
            if (operator == PyTokenTypes.PLUS) continue;
            return false;
        }
        Collection<PyExpression> expressions = PyStringConcatenationToFormatIntention.getSimpleExpressions((PyBinaryExpression)element);
        if (expressions.size() == 0) {
            return false;
        }
        PyBuiltinCache cache = PyBuiltinCache.getInstance(element);
        for (PyExpression expression : expressions) {
            if (expression == null) {
                return false;
            }
            if (expression instanceof PyStringLiteralExpression) continue;
            PyType type = TypeEvalContext.codeAnalysis(file.getProject(), file).getType(expression);
            boolean isStringReference = PyTypeChecker.match(cache.getStringType(LanguageLevel.forElement((PsiElement)expression)), type, TypeEvalContext.codeAnalysis(file.getProject(), file)) && type != null;
            if (isStringReference) continue;
            return false;
        }
        if (LanguageLevel.forElement(element).isAtLeast(LanguageLevel.PYTHON27)) {
            this.setText(PyBundle.message("INTN.replace.plus.with.str.format", new Object[0]));
        } else {
            this.setText(PyBundle.message("INTN.replace.plus.with.format.operator", new Object[0]));
        }
        return true;
    }

    private static Collection<PyExpression> getSimpleExpressions(@NotNull PyBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/intentions/PyStringConcatenationToFormatIntention", "getSimpleExpressions"));
        }
        ArrayList<PyExpression> res = new ArrayList<PyExpression>();
        if (expression.getLeftExpression() instanceof PyBinaryExpression) {
            res.addAll(PyStringConcatenationToFormatIntention.getSimpleExpressions((PyBinaryExpression)expression.getLeftExpression()));
        } else {
            res.add(expression.getLeftExpression());
        }
        if (expression.getRightExpression() instanceof PyBinaryExpression) {
            res.addAll(PyStringConcatenationToFormatIntention.getSimpleExpressions((PyBinaryExpression)expression.getRightExpression()));
        } else {
            res.add(expression.getRightExpression());
        }
        return res;
    }

    private static Collection<PyElementType> getOperators(@NotNull PyBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/intentions/PyStringConcatenationToFormatIntention", "getOperators"));
        }
        ArrayList<PyElementType> res = new ArrayList<PyElementType>();
        if (expression.getLeftExpression() instanceof PyBinaryExpression) {
            res.addAll(PyStringConcatenationToFormatIntention.getOperators((PyBinaryExpression)expression.getLeftExpression()));
        }
        if (expression.getRightExpression() instanceof PyBinaryExpression) {
            res.addAll(PyStringConcatenationToFormatIntention.getOperators((PyBinaryExpression)expression.getRightExpression()));
        }
        res.add(expression.getOperator());
        return res;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyStringConcatenationToFormatIntention", "invoke"));
        }
        PsiElement element = PsiTreeUtil.getTopmostParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyBinaryExpression.class);
        if (element == null) {
            return;
        }
        LanguageLevel languageLevel = LanguageLevel.forElement(element);
        boolean useFormatMethod = languageLevel.isAtLeast(LanguageLevel.PYTHON27);
        NotNullFunction escaper = StringUtil.escaper((boolean)false, (String)"\"'\\");
        StringBuilder stringLiteral = new StringBuilder();
        ArrayList<String> parameters = new ArrayList<String>();
        Pair<String, String> quotes = Pair.create((Object)"\"", (Object)"\"");
        boolean quotesDetected = false;
        TypeEvalContext context = TypeEvalContext.userInitiated(file.getProject(), file);
        int paramCount = 0;
        boolean isUnicode = false;
        PyClassTypeImpl unicodeType = PyBuiltinCache.getInstance(element).getObjectType("unicode");
        for (PyExpression expression : PyStringConcatenationToFormatIntention.getSimpleExpressions((PyBinaryExpression)element)) {
            if (expression instanceof PyStringLiteralExpression) {
                PyType type = context.getType(expression);
                if (type != null && type.equals(unicodeType)) {
                    isUnicode = true;
                }
                if (!quotesDetected) {
                    quotes = PythonStringUtil.getQuotes(expression.getText());
                    quotesDetected = true;
                }
                String value = ((PyStringLiteralExpression)expression).getStringValue();
                if (!useFormatMethod) {
                    value = value.replace("%", "%%");
                }
                stringLiteral.append((String)escaper.fun((Object)value));
                continue;
            }
            PyStringConcatenationToFormatIntention.addParamToString(stringLiteral, paramCount, useFormatMethod);
            parameters.add(expression.getText());
            ++paramCount;
        }
        if (quotes == null) {
            quotes = Pair.create((Object)"\"", (Object)"\"");
        }
        stringLiteral.insert(0, (String)quotes.getFirst());
        if (isUnicode && !((String)quotes.getFirst()).toLowerCase().contains("u")) {
            stringLiteral.insert(0, "u");
        }
        stringLiteral.append((String)quotes.getSecond());
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        if (!parameters.isEmpty()) {
            PyExpression expression;
            if (useFormatMethod) {
                stringLiteral.append(".format(").append(StringUtil.join(parameters, (String)",")).append(")");
            } else {
                String paramString = parameters.size() > 1 ? "(" + StringUtil.join(parameters, (String)",") + ")" : StringUtil.join(parameters, (String)",");
                stringLiteral.append(" % ").append(paramString);
            }
            expression = elementGenerator.createFromText(LanguageLevel.getDefault(), PyExpressionStatement.class, stringLiteral.toString()).getExpression();
            element.replace((PsiElement)expression);
        } else {
            PyStringLiteralExpression stringLiteralExpression = elementGenerator.createStringLiteralAlreadyEscaped(stringLiteral.toString());
            element.replace((PsiElement)stringLiteralExpression);
        }
    }

    private static void addParamToString(StringBuilder stringLiteral, int i, boolean useFormatMethod) {
        if (useFormatMethod) {
            stringLiteral.append("{").append(i).append("}");
        } else {
            stringLiteral.append("%s");
        }
    }
}

