/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;

public class PySplitIfIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.split.if", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PySplitIfIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PySplitIfIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PsiElement elementAtOffset = file.findElementAt(editor.getCaretModel().getOffset());
        if (elementAtOffset == null || elementAtOffset.getNode() == null) {
            return false;
        }
        IElementType elementType = elementAtOffset.getNode().getElementType();
        if (elementType == PyTokenTypes.COLON) {
            elementAtOffset = elementAtOffset.getPrevSibling();
            elementAtOffset = PyUtil.getFirstNonCommentBefore(elementAtOffset);
        } else if (elementType == PyTokenTypes.IF_KEYWORD) {
            elementAtOffset = elementAtOffset.getNextSibling();
            elementAtOffset = PyUtil.getFirstNonCommentAfter(elementAtOffset);
        }
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, PyBinaryExpression.class, (boolean)false);
        if (element == null) {
            return false;
        }
        while (element.getParent() instanceof PyBinaryExpression) {
            element = element.getParent();
        }
        if (((PyBinaryExpression)element).getOperator() != PyTokenTypes.AND_KEYWORD || ((PyBinaryExpression)element).getRightExpression() == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PyIfPart)) {
            return false;
        }
        this.setText(PyBundle.message("INTN.split.if.text", new Object[0]));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PySplitIfIntention", "invoke"));
        }
        PsiElement elementAtOffset = file.findElementAt(editor.getCaretModel().getOffset());
        IElementType elementType = elementAtOffset.getNode().getElementType();
        if (elementType == PyTokenTypes.COLON) {
            elementAtOffset = elementAtOffset.getPrevSibling();
            elementAtOffset = PyUtil.getFirstNonCommentBefore(elementAtOffset);
        } else if (elementType == PyTokenTypes.IF_KEYWORD) {
            elementAtOffset = elementAtOffset.getNextSibling();
            elementAtOffset = PyUtil.getFirstNonCommentAfter(elementAtOffset);
        }
        PyBinaryExpression element = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, PyBinaryExpression.class, (boolean)false);
        while (element.getParent() instanceof PyBinaryExpression) {
            element = (PyBinaryExpression)element.getParent();
        }
        PyIfStatement ifStatement = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyIfStatement.class);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PyIfStatement subIf = (PyIfStatement)ifStatement.copy();
        subIf.getIfPart().getCondition().replace((PsiElement)element.getRightExpression());
        ifStatement.getIfPart().getCondition().replace((PsiElement)element.getLeftExpression());
        PyStatementList statementList = elementGenerator.createFromText(LanguageLevel.getDefault(), PyIfStatement.class, "if a:\n    a = 1").getIfPart().getStatementList();
        statementList.getStatements()[0].replace((PsiElement)subIf);
        PyIfStatement newIf = elementGenerator.createFromText(LanguageLevel.getDefault(), PyIfStatement.class, "if a:\n    a = 1");
        newIf.getIfPart().getCondition().replace((PsiElement)ifStatement.getIfPart().getCondition());
        newIf.getIfPart().getStatementList().replace((PsiElement)statementList);
        for (PyIfPart elif : ifStatement.getElifParts()) {
            newIf.add((PsiElement)elif);
        }
        if (ifStatement.getElsePart() != null) {
            newIf.add((PsiElement)ifStatement.getElsePart());
        }
        ifStatement.replace((PsiElement)newIf);
    }
}

