/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import org.jetbrains.annotations.NotNull;

public class PyQuotedStringIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.quoted.string", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyQuotedStringIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyQuotedStringIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyStringLiteralExpression string = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyStringLiteralExpression.class);
        if (string != null) {
            PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)string, PyDocStringOwner.class);
            if (docStringOwner != null && docStringOwner.getDocStringExpression() == string) {
                return false;
            }
            String stringText = string.getText();
            int prefixLength = PyStringLiteralExpressionImpl.getPrefixLength(stringText);
            if ((stringText = stringText.substring(prefixLength)).length() >= 6 && (stringText.startsWith("'''") && stringText.endsWith("'''") || stringText.startsWith("\"\"\"") && stringText.endsWith("\"\"\""))) {
                return false;
            }
            if (stringText.length() > 2) {
                if (stringText.startsWith("'") && stringText.endsWith("'")) {
                    this.setText(PyBundle.message("INTN.quoted.string.single.to.double", new Object[0]));
                    return true;
                }
                if (stringText.startsWith("\"") && stringText.endsWith("\"")) {
                    this.setText(PyBundle.message("INTN.quoted.string.double.to.single", new Object[0]));
                    return true;
                }
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyQuotedStringIntention", "invoke"));
        }
        PyStringLiteralExpression string = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyStringLiteralExpression.class);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        if (string != null) {
            PyStringLiteralExpression st;
            String result;
            int prefixLength;
            String stringText = string.getText();
            String text = stringText.substring(prefixLength = PyStringLiteralExpressionImpl.getPrefixLength(stringText));
            if (text.startsWith("'") && text.endsWith("'")) {
                result = PyQuotedStringIntention.convertSingleToDoubleQuoted(stringText);
                st = elementGenerator.createStringLiteralAlreadyEscaped(result);
                string.replace(st);
            }
            if (text.startsWith("\"") && text.endsWith("\"")) {
                result = PyQuotedStringIntention.convertDoubleToSingleQuoted(stringText);
                st = elementGenerator.createStringLiteralAlreadyEscaped(result);
                string.replace(st);
            }
        }
    }

    private static String convertDoubleToSingleQuoted(String stringText) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean skipNext = false;
        char[] charArr = stringText.toCharArray();
        for (int i = 0; i != charArr.length; ++i) {
            char ch = charArr[i];
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if (ch == '\"') {
                stringBuilder.append('\'');
                continue;
            }
            if (ch == '\'') {
                stringBuilder.append("\\'");
                continue;
            }
            if (ch == '\\' && charArr[i + 1] == '\"' && i + 2 != charArr.length) {
                skipNext = true;
                stringBuilder.append(charArr[i + 1]);
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }

    private static String convertSingleToDoubleQuoted(String stringText) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean skipNext = false;
        char[] charArr = stringText.toCharArray();
        for (int i = 0; i != charArr.length; ++i) {
            char ch = charArr[i];
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if (ch == '\'') {
                stringBuilder.append('\"');
                continue;
            }
            if (ch == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            if (ch == '\\' && charArr[i + 1] == '\'' && i + 2 != charArr.length) {
                skipNext = true;
                stringBuilder.append(charArr[i + 1]);
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }
}

