/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyNegateComparisonIntention
extends BaseIntentionAction {
    private static final Map<PyElementType, String> comparisonStrings = new HashMap<PyElementType, String>(7);
    private static final Map<PyElementType, PyElementType> invertedComparasions = new HashMap<PyElementType, PyElementType>(7);

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.negate.comparison", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyNegateComparisonIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyNegateComparisonIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PyBinaryExpression binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyBinaryExpression.class, (boolean)false);
        while (binaryExpression != null) {
            PyElementType operator = binaryExpression.getOperator();
            if (comparisonStrings.containsKey((Object)operator)) {
                this.setText(PyBundle.message("INTN.negate.$0.to.$1", comparisonStrings.get((Object)operator), comparisonStrings.get((Object)invertedComparasions.get((Object)operator))));
                return true;
            }
            binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, PyBinaryExpression.class);
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyNegateComparisonIntention", "invoke"));
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PyBinaryExpression binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyBinaryExpression.class, (boolean)false);
        while (binaryExpression != null) {
            PyElementType operator = binaryExpression.getOperator();
            if (comparisonStrings.containsKey((Object)operator)) {
                PsiElement parent = binaryExpression.getParent();
                while (parent instanceof PyParenthesizedExpression) {
                    parent = parent.getParent();
                }
                PyElementType invertedOperator = invertedComparasions.get((Object)binaryExpression.getOperator());
                PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
                PyBinaryExpression newElement = elementGenerator.createBinaryExpression(comparisonStrings.get((Object)invertedOperator), binaryExpression.getLeftExpression(), binaryExpression.getRightExpression());
                if (parent instanceof PyPrefixExpression && ((PyPrefixExpression)parent).getOperator() == PyTokenTypes.NOT_KEYWORD) {
                    parent.replace((PsiElement)newElement);
                } else {
                    binaryExpression.replace((PsiElement)elementGenerator.createExpressionFromText("not " + newElement.getText()));
                }
                return;
            }
            binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, PyBinaryExpression.class);
        }
    }

    static {
        comparisonStrings.put(PyTokenTypes.LT, "<");
        comparisonStrings.put(PyTokenTypes.GT, ">");
        comparisonStrings.put(PyTokenTypes.EQEQ, "==");
        comparisonStrings.put(PyTokenTypes.LE, "<=");
        comparisonStrings.put(PyTokenTypes.GE, ">=");
        comparisonStrings.put(PyTokenTypes.NE, "!=");
        comparisonStrings.put(PyTokenTypes.NE_OLD, "<>");
        invertedComparasions.put(PyTokenTypes.LT, PyTokenTypes.GE);
        invertedComparasions.put(PyTokenTypes.GT, PyTokenTypes.LE);
        invertedComparasions.put(PyTokenTypes.EQEQ, PyTokenTypes.NE);
        invertedComparasions.put(PyTokenTypes.LE, PyTokenTypes.GT);
        invertedComparasions.put(PyTokenTypes.GE, PyTokenTypes.LT);
        invertedComparasions.put(PyTokenTypes.NE, PyTokenTypes.EQEQ);
        invertedComparasions.put(PyTokenTypes.NE_OLD, PyTokenTypes.EQEQ);
    }
}

