/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyJoinIfIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.join.if", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyJoinIfIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.join.if.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyJoinIfIntention", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyJoinIfIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyIfStatement expression = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyIfStatement.class);
        PyIfStatement outer = PyJoinIfIntention.getIfStatement(expression);
        if (outer != null) {
            if (outer.getElsePart() != null || outer.getElifParts().length > 0) {
                return false;
            }
            PyStatement firstStatement = PyJoinIfIntention.getFirstStatement(outer);
            PyStatementList outerStList = outer.getIfPart().getStatementList();
            if (outerStList != null && outerStList.getStatements().length != 1) {
                return false;
            }
            if (firstStatement instanceof PyIfStatement) {
                PyIfStatement inner = (PyIfStatement)firstStatement;
                if (inner.getElsePart() != null || inner.getElifParts().length > 0) {
                    return false;
                }
                PyStatementList stList = inner.getIfPart().getStatementList();
                if (stList != null && stList.getStatements().length != 0) {
                    return true;
                }
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyJoinIfIntention", "invoke"));
        }
        PyIfStatement expression = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyIfStatement.class);
        PyIfStatement ifStatement = PyJoinIfIntention.getIfStatement(expression);
        PyStatement firstStatement = PyJoinIfIntention.getFirstStatement(ifStatement);
        if (ifStatement == null) {
            return;
        }
        if (firstStatement != null && firstStatement instanceof PyIfStatement) {
            PyExpression condition = ((PyIfStatement)firstStatement).getIfPart().getCondition();
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            PyExpression ifCondition = ifStatement.getIfPart().getCondition();
            if (ifCondition == null || condition == null) {
                return;
            }
            StringBuilder replacementText = new StringBuilder(ifCondition.getText() + " and ");
            if (condition instanceof PyBinaryExpression && ((PyBinaryExpression)condition).getOperator() == PyTokenTypes.OR_KEYWORD) {
                replacementText.append("(").append(condition.getText()).append(")");
            } else {
                replacementText.append(condition.getText());
            }
            PyExpression newCondition = elementGenerator.createExpressionFromText(replacementText.toString());
            ifCondition.replace((PsiElement)newCondition);
            PyStatementList stList = ((PyIfStatement)firstStatement).getIfPart().getStatementList();
            PyStatementList ifStatementList = ifStatement.getIfPart().getStatementList();
            if (ifStatementList == null || stList == null) {
                return;
            }
            List comments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)ifStatement.getIfPart(), PsiComment.class);
            comments.addAll(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)((PyIfStatement)firstStatement).getIfPart(), PsiComment.class));
            comments.addAll(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)ifStatementList, PsiComment.class));
            comments.addAll(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)stList, PsiComment.class));
            for (PsiComment comm : comments) {
                ifStatement.getIfPart().addBefore((PsiElement)comm, (PsiElement)ifStatementList);
                comm.delete();
            }
            ifStatementList.replace((PsiElement)stList);
        }
    }

    @Nullable
    private static PyStatement getFirstStatement(PyIfStatement ifStatement) {
        PyStatementList stList;
        PyStatement firstStatement = null;
        if (ifStatement != null && (stList = ifStatement.getIfPart().getStatementList()) != null && stList.getStatements().length != 0) {
            firstStatement = stList.getStatements()[0];
        }
        return firstStatement;
    }

    @Nullable
    private static PyIfStatement getIfStatement(PyIfStatement expression) {
        PyStatement firstStatement;
        PyStatementList stList;
        while (!(expression == null || (stList = expression.getIfPart().getStatementList()) != null && stList.getStatements().length != 0 && (firstStatement = stList.getStatements()[0]) instanceof PyIfStatement)) {
            expression = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PyIfStatement.class);
        }
        return expression;
    }
}

