/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.documentation.PyDocstringGenerator;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;

public class PyGenerateDocstringIntention
extends BaseIntentionAction {
    private String myText;

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.doc.string.stub", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyGenerateDocstringIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyGenerateDocstringIntention", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyGenerateDocstringIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile) || file instanceof PyDocstringFile) {
            return false;
        }
        PsiElement elementAt = PyUtil.findNonWhitespaceAtOffset(file, editor.getCaretModel().getOffset());
        if (elementAt == null) {
            return false;
        }
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyFunction.class);
        PyStatementList statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyStatementList.class, (boolean)false, (Class[])new Class[]{PyFunction.class});
        if (function == null || statementList != null) {
            return false;
        }
        if (!elementAt.equals(function.getNameNode())) {
            return false;
        }
        return this.isAvailableForFunction(project, function);
    }

    private boolean isAvailableForFunction(Project project, PyFunction function) {
        if (function.getDocStringValue() != null) {
            PySignature signature = PySignatureCacheManager.getInstance(project).findSignature(function);
            PyDocstringGenerator docstringGenerator = new PyDocstringGenerator(function);
            docstringGenerator.addFunctionArguments(function, signature);
            if (docstringGenerator.haveParametersToAdd()) {
                this.myText = PyBundle.message("INTN.add.parameters.to.docstring", new Object[0]);
                return true;
            }
            return false;
        }
        this.myText = PyBundle.message("INTN.doc.string.stub", new Object[0]);
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyGenerateDocstringIntention", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file)) {
            return;
        }
        PsiElement elementAt = PyUtil.findNonWhitespaceAtOffset(file, editor.getCaretModel().getOffset());
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyFunction.class);
        if (function == null) {
            return;
        }
        PyGenerateDocstringIntention.generateDocstringForFunction(project, editor, function);
    }

    public static void generateDocstringForFunction(Project project, Editor editor, PyFunction function) {
        Module module = ModuleManager.getInstance((Project)project).getModules()[0];
        PyDocumentationSettings documentationSettings = PyDocumentationSettings.getInstance(module);
        if (documentationSettings.isPlain(function.getContainingFile())) {
            String[] values = new String[]{"Epytext", "reStructuredText"};
            int i = Messages.showChooseDialog((String)"Docstring format:", (String)"Select Docstring Type", (String[])values, (String)"Epytext", null);
            if (i < 0) {
                return;
            }
            String value = values[i];
            documentationSettings.setFormat(value);
        }
        PyDocstringGenerator docstringGenerator = new PyDocstringGenerator(function).withSignatures();
        if (function.getDocStringValue() == null) {
            docstringGenerator.withReturn();
        }
        docstringGenerator.build();
    }
}

