/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyFile;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyFlipComparisonIntention
extends BaseIntentionAction {
    private static final Map<PyElementType, String> FLIPPED_OPERATORS = new HashMap(7);

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.flip.comparison", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyFlipComparisonIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyFlipComparisonIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PyBinaryExpression binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyBinaryExpression.class, (boolean)false);
        while (binaryExpression != null) {
            PyElementType operator = binaryExpression.getOperator();
            if (FLIPPED_OPERATORS.containsKey((Object)operator)) {
                String operatorText = binaryExpression.getPsiOperator().getText();
                String flippedOperatorText = FLIPPED_OPERATORS.get((Object)operator);
                if (flippedOperatorText.equals(operatorText)) {
                    this.setText(PyBundle.message("INTN.flip.$0", operatorText));
                } else {
                    this.setText(PyBundle.message("INTN.flip.$0.to.$1", operatorText, flippedOperatorText));
                }
                return true;
            }
            binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, PyBinaryExpression.class);
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyFlipComparisonIntention", "invoke"));
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PyBinaryExpression binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyBinaryExpression.class, (boolean)false);
        while (binaryExpression != null) {
            if (FLIPPED_OPERATORS.containsKey((Object)binaryExpression.getOperator())) {
                PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
                binaryExpression.replace((PsiElement)elementGenerator.createBinaryExpression(FLIPPED_OPERATORS.get((Object)binaryExpression.getOperator()), binaryExpression.getRightExpression(), binaryExpression.getLeftExpression()));
                return;
            }
            binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, PyBinaryExpression.class);
        }
    }

    static {
        FLIPPED_OPERATORS.put(PyTokenTypes.EQEQ, "==");
        FLIPPED_OPERATORS.put(PyTokenTypes.NE, "!=");
        FLIPPED_OPERATORS.put(PyTokenTypes.NE_OLD, "<>");
        FLIPPED_OPERATORS.put(PyTokenTypes.GE, "<=");
        FLIPPED_OPERATORS.put(PyTokenTypes.LE, ">=");
        FLIPPED_OPERATORS.put(PyTokenTypes.GT, "<");
        FLIPPED_OPERATORS.put(PyTokenTypes.LT, ">");
    }
}

