/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.NotNull;

public class PyDictLiteralFormToConstructorIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.convert.dict.literal.to.dict.constructor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyDictLiteralFormToConstructorIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.convert.dict.literal.to.dict.constructor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyDictLiteralFormToConstructorIntention", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyDictLiteralFormToConstructorIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyDictLiteralExpression dictExpression = (PyDictLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyDictLiteralExpression.class);
        if (dictExpression != null) {
            PyKeyValueExpression[] elements = dictExpression.getElements();
            if (elements.length != 0) {
                for (PyKeyValueExpression element : elements) {
                    PyExpression key = element.getKey();
                    if (!(key instanceof PyStringLiteralExpression)) {
                        return false;
                    }
                    String str = ((PyStringLiteralExpression)key).getStringValue();
                    if (PyNames.isReserved(str)) {
                        return false;
                    }
                    if (str.length() == 0 || Character.isDigit(str.charAt(0))) {
                        return false;
                    }
                    if (StringUtil.isJavaIdentifier((String)str)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyDictLiteralFormToConstructorIntention", "invoke"));
        }
        PyDictLiteralExpression dictExpression = (PyDictLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyDictLiteralExpression.class);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        if (dictExpression != null) {
            PyDictLiteralFormToConstructorIntention.replaceDictLiteral(dictExpression, elementGenerator);
        }
    }

    private static void replaceDictLiteral(PyDictLiteralExpression dictExpression, PyElementGenerator elementGenerator) {
        PyKeyValueExpression[] argumentList = dictExpression.getElements();
        StringBuilder stringBuilder = new StringBuilder("dict(");
        int size = argumentList.length;
        for (int i = 0; i != size; ++i) {
            PyKeyValueExpression argument = argumentList[i];
            if (!(argument instanceof PyKeyValueExpression)) continue;
            PyExpression key = argument.getKey();
            PyExpression value = argument.getValue();
            if (!(key instanceof PyStringLiteralExpression) || value == null) continue;
            stringBuilder.append(((PyStringLiteralExpression)key).getStringValue());
            stringBuilder.append("=");
            stringBuilder.append(value.getText());
            if (i == size - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        PyCallExpression callExpression = (PyCallExpression)elementGenerator.createFromText(LanguageLevel.forElement((PsiElement)dictExpression), PyExpressionStatement.class, stringBuilder.toString()).getExpression();
        dictExpression.replace((PsiElement)callExpression);
    }
}

