/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public class PyDictConstructorToLiteralFormIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.convert.dict.constructor.to.dict.literal", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyDictConstructorToLiteralFormIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.convert.dict.constructor.to.dict.literal", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyDictConstructorToLiteralFormIntention", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        TypeEvalContext context;
        PyType type;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyDictConstructorToLiteralFormIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyCallExpression expression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyCallExpression.class);
        if (expression != null && expression.isCalleeText("dict") && (type = (context = TypeEvalContext.codeAnalysis(file.getProject(), file)).getType(expression)) != null && type.isBuiltin()) {
            PyExpression[] argumentList;
            for (PyExpression argument : argumentList = expression.getArguments()) {
                if (argument instanceof PyKeywordArgument) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyDictConstructorToLiteralFormIntention", "invoke"));
        }
        PyCallExpression expression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyCallExpression.class);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        if (expression != null) {
            PyDictConstructorToLiteralFormIntention.replaceDictConstructor(expression, elementGenerator);
        }
    }

    private static void replaceDictConstructor(PyCallExpression expression, PyElementGenerator elementGenerator) {
        PyExpression[] argumentList = expression.getArguments();
        StringBuilder stringBuilder = new StringBuilder();
        int size = argumentList.length;
        for (int i = 0; i != size; ++i) {
            PyExpression argument = argumentList[i];
            if (!(argument instanceof PyKeywordArgument)) continue;
            stringBuilder.append("'");
            stringBuilder.append(((PyKeywordArgument)argument).getKeyword());
            stringBuilder.append("' : ");
            stringBuilder.append(((PyKeywordArgument)argument).getValueExpression().getText());
            if (i == size - 1) continue;
            stringBuilder.append(",");
        }
        PyDictLiteralExpression dict = (PyDictLiteralExpression)elementGenerator.createFromText(LanguageLevel.forElement((PsiElement)expression), PyExpressionStatement.class, "{" + stringBuilder.toString() + "}").getExpression();
        expression.replace((PsiElement)dict);
    }
}

