/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyPrefixExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDemorganIntention
extends BaseIntentionAction {
    @NotNull
    public String getText() {
        if ("DeMorgan Law" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyDemorganIntention", "getText"));
        }
        return "DeMorgan Law";
    }

    @NotNull
    public String getFamilyName() {
        if ("DeMorgan Law" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyDemorganIntention", "getFamilyName"));
        }
        return "DeMorgan Law";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PyElementType op;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyDemorganIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyBinaryExpression expression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyBinaryExpression.class);
        return expression != null && ((op = expression.getOperator()) == PyTokenTypes.AND_KEYWORD || op == PyTokenTypes.OR_KEYWORD);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyDemorganIntention", "invoke"));
        }
        PyBinaryExpression expression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyBinaryExpression.class);
        PyElementType op = expression.getOperator();
        String converted = PyDemorganIntention.convertConjunctionExpression(expression, op);
        PyDemorganIntention.replaceExpression(converted, expression);
    }

    private static void replaceExpression(String newExpression, PyBinaryExpression expression) {
        PyBinaryExpression expressionToReplace = expression;
        String expString = "not(" + newExpression + ')';
        PsiElement parent = expression.getParent().getParent();
        if (PyDemorganIntention.isNegation(parent)) {
            expressionToReplace = parent;
            expString = newExpression;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(expression.getProject());
        PyExpression newCall = generator.createExpressionFromText(expString);
        PsiElement insertedElement = expressionToReplace.replace((PsiElement)newCall);
    }

    private static String convertConjunctionExpression(PyBinaryExpression exp, PyElementType tokenType) {
        PyExpression lhs = exp.getLeftExpression();
        String lhsText = PyDemorganIntention.isConjunctionExpression(lhs, tokenType) ? PyDemorganIntention.convertConjunctionExpression((PyBinaryExpression)lhs, tokenType) : PyDemorganIntention.convertLeafExpression(lhs);
        PyExpression rhs = exp.getRightExpression();
        String rhsText = PyDemorganIntention.isConjunctionExpression(rhs, tokenType) ? PyDemorganIntention.convertConjunctionExpression((PyBinaryExpression)rhs, tokenType) : PyDemorganIntention.convertLeafExpression(rhs);
        String flippedConjunction = tokenType == PyTokenTypes.AND_KEYWORD ? " or " : " and ";
        return lhsText + flippedConjunction + rhsText;
    }

    private static String convertLeafExpression(PyExpression condition) {
        if (PyDemorganIntention.isNegation((PsiElement)condition)) {
            PyExpression negated = PyDemorganIntention.getNegated(condition);
            if (negated == null) {
                return "";
            }
            return negated.getText();
        }
        if (condition instanceof PyBinaryExpression) {
            return "not(" + condition.getText() + ")";
        }
        return "not " + condition.getText();
    }

    @Nullable
    private static PyExpression getNegated(PyExpression expression) {
        PyExpression operand = ((PyPrefixExpression)expression).getOperand();
        return operand;
    }

    private static boolean isConjunctionExpression(PyExpression expression, PyElementType tokenType) {
        if (expression instanceof PyBinaryExpression) {
            PyElementType operator = ((PyBinaryExpression)expression).getOperator();
            return operator == tokenType;
        }
        return false;
    }

    private static boolean isNegation(PsiElement expression) {
        if (!(expression instanceof PyPrefixExpression)) {
            return false;
        }
        PyElementType op = ((PyPrefixExpression)expression).getOperator();
        return op == PyTokenTypes.NOT_KEYWORD;
    }
}

