/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyConvertTripleQuotedStringIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.triple.quoted.string", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyConvertTripleQuotedStringIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.triple.quoted.string", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyConvertTripleQuotedStringIntention", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyConvertTripleQuotedStringIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyStringLiteralExpression string = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyStringLiteralExpression.class);
        if (string != null) {
            PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)string, PyDocStringOwner.class);
            if (docStringOwner != null && docStringOwner.getDocStringExpression() == string) {
                return false;
            }
            String stringText = string.getText();
            int prefixLength = PyStringLiteralExpressionImpl.getPrefixLength(stringText);
            if ((stringText = stringText.substring(prefixLength)).length() >= 6 && (stringText.startsWith("'''") && stringText.endsWith("'''") || stringText.startsWith("\"\"\"") && stringText.endsWith("\"\"\""))) {
                return true;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyConvertTripleQuotedStringIntention", "invoke"));
        }
        PyStringLiteralExpression string = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyStringLiteralExpression.class);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        if (string != null) {
            PsiElement parent = string.getParent();
            String stringText = string.getText();
            int prefixLength = PyStringLiteralExpressionImpl.getPrefixLength(stringText);
            String prefix = stringText.substring(0, prefixLength);
            Character firstQuote = Character.valueOf(stringText.substring(prefixLength).charAt(0));
            stringText = string.getStringValue();
            List subStrings = StringUtil.split((String)stringText, (String)"\n", (boolean)false, (boolean)true);
            StringBuilder result = new StringBuilder();
            if (subStrings.size() != 1) {
                result.append("(");
            }
            boolean lastString = false;
            for (String s : subStrings) {
                result.append(prefix);
                result.append(firstQuote);
                String validSubstring = PyConvertTripleQuotedStringIntention.convertToValidSubString(s, firstQuote);
                if (s.endsWith("'''") || s.endsWith("\"\"\"")) {
                    lastString = true;
                }
                result.append(validSubstring);
                result.append(firstQuote);
                if (lastString) continue;
                result.append(" ").append("\n");
            }
            if (subStrings.size() != 1) {
                result.append(")");
            }
            PyExpressionStatement e = elementGenerator.createFromText(LanguageLevel.forElement(string), PyExpressionStatement.class, result.toString());
            PyExpression expression = e.getExpression();
            if ((parent instanceof PyParenthesizedExpression || parent instanceof PyTupleExpression) && expression instanceof PyParenthesizedExpression) {
                expression = ((PyParenthesizedExpression)expression).getContainedExpression();
            }
            if (expression != null) {
                string.replace((PsiElement)expression);
            }
        }
    }

    private static String convertToValidSubString(String s, Character firstQuote) {
        String subString;
        if (s.startsWith("'''") || s.startsWith("\"\"\"")) {
            subString = PyConvertTripleQuotedStringIntention.convertToValidSubString(s.substring(3), firstQuote);
        } else if (s.endsWith("'''") || s.endsWith("\"\"\"")) {
            String trimmed = s.trim();
            subString = PyConvertTripleQuotedStringIntention.convertToValidSubString(trimmed.substring(0, trimmed.length() - 3), firstQuote);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder = StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)String.valueOf(firstQuote), (boolean)true, (StringBuilder)stringBuilder);
            subString = stringBuilder.toString();
        }
        return subString;
    }
}

