/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyConvertMethodToPropertyIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.convert.method.to.property", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyConvertMethodToPropertyIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.convert.method.to.property", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyConvertMethodToPropertyIntention", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyConvertMethodToPropertyIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        if (!LanguageLevel.forElement((PsiElement)file).isAtLeast(LanguageLevel.PYTHON26)) {
            return false;
        }
        PsiElement element = PyUtil.findNonWhitespaceAtOffset(file, editor.getCaretModel().getOffset());
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (function == null) {
            return false;
        }
        PyClass containingClass = function.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (function.getParameterList().getParameters().length > 1) {
            return false;
        }
        PyDecoratorList decoratorList = function.getDecoratorList();
        if (decoratorList != null) {
            return false;
        }
        final boolean[] available = new boolean[]{false};
        function.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReturnStatement(PyReturnStatement node) {
                if (node.getExpression() != null) {
                    available[0] = true;
                }
            }

            @Override
            public void visitPyYieldExpression(PyYieldExpression node) {
                available[0] = true;
            }
        });
        return available[0];
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyConvertMethodToPropertyIntention", "invoke"));
        }
        PsiElement element = PyUtil.findNonWhitespaceAtOffset(file, editor.getCaretModel().getOffset());
        PyFunction problemFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (problemFunction == null) {
            return;
        }
        PyClass containingClass = problemFunction.getContainingClass();
        if (containingClass == null) {
            return;
        }
        List<UsageInfo> usages = PyRefactoringUtil.findUsages(problemFunction, false);
        PyDecoratorList problemDecoratorList = problemFunction.getDecoratorList();
        ArrayList<String> decoTexts = new ArrayList<String>();
        decoTexts.add("@property");
        if (problemDecoratorList != null) {
            PyDecorator[] decorators;
            for (PyDecorator deco : decorators = problemDecoratorList.getDecorators()) {
                decoTexts.add(deco.getText());
            }
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        PyDecoratorList decoratorList = generator.createDecoratorList(decoTexts.toArray(new String[decoTexts.size()]));
        if (problemDecoratorList != null) {
            problemDecoratorList.replace((PsiElement)decoratorList);
        } else {
            problemFunction.addBefore((PsiElement)decoratorList, problemFunction.getFirstChild());
        }
        for (UsageInfo usage : usages) {
            PyArgumentList argumentList;
            PsiElement parent;
            PsiElement usageElement = usage.getElement();
            if (!(usageElement instanceof PyReferenceExpression) || !((parent = usageElement.getParent()) instanceof PyCallExpression) || (argumentList = ((PyCallExpression)parent).getArgumentList()) == null) continue;
            argumentList.delete();
        }
    }
}

