/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.codeFragment.PyCodeFragmentUtil;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.refactoring.introduce.IntroduceValidator;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyConvertLambdaToFunctionIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.convert.lambda.to.function", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyConvertLambdaToFunctionIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.convert.lambda.to.function", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/PyConvertLambdaToFunctionIntention", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyConvertLambdaToFunctionIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyLambdaExpression lambdaExpression = (PyLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyLambdaExpression.class);
        if (lambdaExpression != null && lambdaExpression.getBody() != null) {
            ControlFlow flow = ControlFlowCache.getControlFlow(lambdaExpression);
            List<Instruction> graph = Arrays.asList(flow.getInstructions());
            List<PsiElement> elements = PyCodeFragmentUtil.getInputElements(graph, graph);
            return elements.size() <= 0;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/PyConvertLambdaToFunctionIntention", "invoke"));
        }
        PyLambdaExpression lambdaExpression = (PyLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyLambdaExpression.class);
        if (lambdaExpression != null) {
            PsiElement statementParent;
            String name = "function";
            while (IntroduceValidator.isDefinedInScope(name, (PsiElement)lambdaExpression)) {
                name = name + "1";
            }
            PsiElement parent = lambdaExpression.getParent();
            if (parent instanceof PyAssignmentStatement) {
                name = ((PyAssignmentStatement)parent).getLeftHandSideExpression().getText();
            }
            if (name.isEmpty()) {
                return;
            }
            PyExpression body = lambdaExpression.getBody();
            PyFunctionBuilder functionBuilder = new PyFunctionBuilder(name);
            for (PyParameter param : lambdaExpression.getParameterList().getParameters()) {
                functionBuilder.parameter(param.getText());
            }
            functionBuilder.statement("return " + body.getText());
            PyFunction function = functionBuilder.buildFunction(project, LanguageLevel.getDefault());
            PyStatement statement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)lambdaExpression, PyStatement.class);
            if (statement != null && (statementParent = statement.getParent()) != null) {
                function = (PyFunction)statementParent.addBefore((PsiElement)function, (PsiElement)statement);
            }
            function = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(function);
            if (parent instanceof PyAssignmentStatement) {
                parent.delete();
            } else {
                PsiFile parentScope = lambdaExpression.getContainingFile();
                TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)parentScope);
                PsiElement functionName = function.getNameIdentifier();
                functionName = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(functionName);
                lambdaExpression = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(lambdaExpression);
                ReferenceNameExpression refExpr = new ReferenceNameExpression(name);
                ((TemplateBuilderImpl)builder).replaceElement((PsiElement)lambdaExpression, name, (Expression)refExpr, true);
                ((TemplateBuilderImpl)builder).replaceElement(functionName, name, name, false);
                int textOffSet = functionName.getTextOffset();
                editor.getCaretModel().moveToOffset(parentScope.getTextRange().getStartOffset());
                Template template = ((TemplateBuilderImpl)builder).buildInlineTemplate();
                TemplateManager.getInstance(project).startTemplate(editor, template);
                editor.getCaretModel().moveToOffset(textOffSet);
            }
        }
    }

    private class ReferenceNameExpression
    extends Expression {
        private final String myOldReferenceName;

        ReferenceNameExpression(String oldReferenceName) {
            this.myOldReferenceName = oldReferenceName;
        }

        public Result calculateResult(ExpressionContext context) {
            return new TextResult(this.myOldReferenceName);
        }

        public Result calculateQuickResult(ExpressionContext context) {
            return null;
        }

        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            return null;
        }
    }
}

