/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.intentions.DeclarationConflictChecker;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ImportToggleAliasIntention
implements IntentionAction {
    private String myLastText;

    @NotNull
    public String getText() {
        String string = this.myLastText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/ImportToggleAliasIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.Family.toggle.import.alias", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/ImportToggleAliasIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/ImportToggleAliasIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        IntentionState state2 = IntentionState.fromContext(editor, file);
        this.myLastText = state2.getText();
        return state2.isAvailable();
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/ImportToggleAliasIntention", "invoke"));
        }
        IntentionState state2 = IntentionState.fromContext(editor, file);
        PyReferenceExpression reference = PyUtil.sure(state2.myImportElement.getImportReferenceExpression());
        try {
            String remove_name;
            String target_name;
            String imported_name = PyPsiUtils.toPath(reference);
            if (state2.myAlias != null) {
                target_name = imported_name;
                remove_name = state2.myAlias;
            } else {
                Application application = ApplicationManager.getApplication();
                if (application != null && !application.isUnitTestMode()) {
                    String alias = Messages.showInputDialog((Project)project, (String)PyBundle.message("INTN.alias.for.$0.dialog.title", imported_name), (String)"Add Alias", (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

                        public boolean checkInput(String inputString) {
                            return PyNames.isIdentifier(inputString);
                        }

                        public boolean canClose(String inputString) {
                            return PyNames.isIdentifier(inputString);
                        }
                    });
                    if (alias == null) {
                        return;
                    }
                    target_name = alias;
                } else {
                    target_name = "alias";
                }
                remove_name = imported_name;
            }
            final PsiElement referee = reference.getReference().resolve();
            if (referee != null && imported_name != null) {
                final ArrayList references = new ArrayList();
                ScopeOwner scope = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)state2.myImportElement, ScopeOwner.class);
                PsiTreeUtil.processElements((PsiElement)scope, (PsiElementProcessor)new PsiElementProcessor(){

                    public boolean execute(@NotNull PsiElement element) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/intentions/ImportToggleAliasIntention$2", "execute"));
                        }
                        this.getReferences(element);
                        if (element instanceof PyStringLiteralExpression) {
                            PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)element;
                            List files = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles((PsiElement)host);
                            if (files != null) {
                                for (Pair pair : files) {
                                    PsiElement first = (PsiElement)pair.getFirst();
                                    if (!(first instanceof ScopeOwner)) continue;
                                    ScopeOwner scopeOwner = (ScopeOwner)first;
                                    PsiTreeUtil.processElements((PsiElement)scopeOwner, (PsiElementProcessor)new PsiElementProcessor(){

                                        public boolean execute(@NotNull PsiElement element) {
                                            if (element == null) {
                                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/intentions/ImportToggleAliasIntention$2$1", "execute"));
                                            }
                                            this.getReferences(element);
                                            return true;
                                        }
                                    });
                                }
                            }
                        }
                        return true;
                    }

                    private void getReferences(PsiElement element) {
                        PsiElement resolved;
                        PyReferenceExpression ref;
                        if (element instanceof PyReferenceExpression && PsiTreeUtil.getParentOfType((PsiElement)element, PyImportElement.class) == null && remove_name.equals(PyPsiUtils.toPath(ref = (PyReferenceExpression)element)) && (resolved = ref.getReference().resolve()) == referee) {
                            references.add(ref.getReference());
                        }
                    }
                });
                if (DeclarationConflictChecker.showConflicts(project, DeclarationConflictChecker.findDefinitions(target_name, references, null), target_name, null)) {
                    return;
                }
                PyElementGenerator generator = PyElementGenerator.getInstance(project);
                LanguageLevel languageLevel = LanguageLevel.forElement(state2.myImportElement);
                if (state2.myAlias != null) {
                    ASTNode node = PyUtil.sure(state2.myImportElement.getNode());
                    ASTNode parent = PyUtil.sure(node.getTreeParent());
                    node = PyUtil.sure(node.getFirstChildNode());
                    node = PyUtil.sure(node.getTreeNext());
                    parent.removeRange(node, null);
                } else {
                    ASTNode my_ielt_node = PyUtil.sure(state2.myImportElement.getNode());
                    PyImportElement fountain = generator.createFromText(languageLevel, PyImportElement.class, "import foo as " + target_name, new int[]{0, 2});
                    ASTNode graft_node = PyUtil.sure(fountain.getNode());
                    graft_node = PyUtil.sure(graft_node.getFirstChildNode());
                    graft_node = PyUtil.sure(graft_node.getTreeNext());
                    my_ielt_node.addChild((ASTNode)graft_node.clone());
                    graft_node = PyUtil.sure(graft_node.getTreeNext());
                    my_ielt_node.addChild((ASTNode)graft_node.clone());
                    graft_node = PyUtil.sure(graft_node.getTreeNext());
                    my_ielt_node.addChild((ASTNode)graft_node.clone());
                    graft_node = PyUtil.sure(graft_node.getTreeNext());
                    my_ielt_node.addChild((ASTNode)graft_node.clone());
                }
                for (PsiReference ref : references) {
                    ASTNode ref_name_node = PyUtil.sure(PyUtil.sure(ref.getElement()).getNode());
                    ASTNode parent = PyUtil.sure(ref_name_node.getTreeParent());
                    ASTNode new_name_node = generator.createExpressionFromText(languageLevel, target_name).getNode();
                    assert (new_name_node != null);
                    parent.replaceChild(ref_name_node, new_name_node);
                }
            }
        }
        catch (IncorrectOperationException ignored) {
            PyUtil.showBalloon(project, PyBundle.message("QFIX.action.failed", new Object[0]), MessageType.WARNING);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static class IntentionState {
        private PyImportElement myImportElement;
        private PyFromImportStatement myFromImportStatement;
        private PyImportStatement myImportStatement;
        private String myAlias;

        private IntentionState() {
        }

        private static IntentionState fromContext(Editor editor, PsiFile file) {
            IntentionState state2 = new IntentionState();
            state2.myImportElement = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyImportElement.class);
            if (state2.myImportElement != null && state2.myImportElement.isValid()) {
                PyTargetExpression target = state2.myImportElement.getAsNameElement();
                state2.myAlias = target != null && target.isValid() ? target.getName() : null;
                state2.myFromImportStatement = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)state2.myImportElement, PyFromImportStatement.class);
                state2.myImportStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)state2.myImportElement, PyImportStatement.class);
            }
            return state2;
        }

        public boolean isAvailable() {
            if (this.myFromImportStatement != null ? !this.myFromImportStatement.isValid() || this.myFromImportStatement.isFromFuture() : this.myImportStatement == null || !this.myImportStatement.isValid()) {
                return false;
            }
            PyReferenceExpression referenceExpression = this.myImportElement.getImportReferenceExpression();
            return referenceExpression != null && referenceExpression.getReference().resolve() != null;
        }

        public String getText() {
            PyReferenceExpression refex;
            String add_name = "Add alias";
            if (this.myImportElement != null && (refex = this.myImportElement.getImportReferenceExpression()) != null) {
                add_name = PyBundle.message("INTN.add.alias.for.import.$0", refex.getText());
            }
            return this.myAlias == null ? add_name : PyBundle.message("INTN.remove.alias.for.import.$0", this.myAlias);
        }
    }
}

