/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.stubs.PyImportStatementStub;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportToImportFromIntention
implements IntentionAction {
    private String myText;

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.Family.convert.import.unqualify", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    private static PyImportElement findImportElement(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention", "findImportElement"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention", "findImportElement"));
        }
        PsiElement elementAtCaret = file.findElementAt(editor.getCaretModel().getOffset());
        PyImportElement importElement = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, PyImportElement.class);
        if (importElement != null && importElement.isValid()) {
            return importElement;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        IntentionState state2 = new IntentionState(editor, file);
        if (state2.isAvailable()) {
            this.myText = state2.getText();
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention", "invoke"));
        }
        IntentionState state2 = new IntentionState(editor, file);
        state2.invoke();
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static class IntentionState {
        private String myModuleName;
        private String myQualifierName;
        private PsiElement myReferee;
        private PyImportElement myImportElement;
        private Collection<PsiReference> myReferences;
        private boolean myHasModuleReference;
        private int myRelativeLevel;

        public IntentionState(@NotNull Editor editor, @NotNull PsiFile file) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention$IntentionState", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention$IntentionState", "<init>"));
            }
            this.myModuleName = null;
            this.myQualifierName = null;
            this.myReferee = null;
            this.myImportElement = null;
            this.myReferences = null;
            this.myHasModuleReference = false;
            boolean available = false;
            this.myImportElement = ImportToImportFromIntention.findImportElement(editor, file);
            if (this.myImportElement != null) {
                PsiElement parent = this.myImportElement.getParent();
                if (parent instanceof PyImportStatement) {
                    this.myRelativeLevel = 0;
                    available = true;
                } else if (parent instanceof PyFromImportStatement) {
                    PyFromImportStatement fromImport = (PyFromImportStatement)parent;
                    int relativeLevel = fromImport.getRelativeLevel();
                    if (fromImport.isValid() && relativeLevel > 0 && fromImport.getImportSource() == null) {
                        this.myRelativeLevel = relativeLevel;
                        available = true;
                    }
                }
            }
            if (available) {
                this.collectReferencesAndOtherData(file);
            }
        }

        public boolean isAvailable() {
            return this.myReferences != null && this.myReferences.size() > 0;
        }

        private void collectReferencesAndOtherData(PsiFile file) {
            assert (this.myImportElement != null) : "isAvailable() must have returned true, but myImportElement is null";
            PyReferenceExpression importReference = this.myImportElement.getImportReferenceExpression();
            if (importReference != null) {
                this.myModuleName = PyPsiUtils.toPath(importReference);
                this.myQualifierName = this.myImportElement.getVisibleName();
                this.myReferee = importReference.getReference().resolve();
                this.myHasModuleReference = false;
                if (this.myReferee != null && this.myModuleName != null && this.myQualifierName != null) {
                    final ArrayList<PsiReference> references = new ArrayList<PsiReference>();
                    PsiTreeUtil.processElements((PsiElement)file, (PsiElementProcessor)new PsiElementProcessor(){

                        public boolean execute(@NotNull PsiElement element) {
                            if (element == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention$IntentionState$1", "execute"));
                            }
                            if (element instanceof PyReferenceExpression && PsiTreeUtil.getParentOfType((PsiElement)element, PyImportElement.class) == null) {
                                PyReferenceExpression ref = (PyReferenceExpression)element;
                                if (IntentionState.this.myQualifierName.equals(PyPsiUtils.toPath(ref))) {
                                    PsiElement parentElt = ref.getParent();
                                    if (parentElt instanceof PyQualifiedExpression) {
                                        PsiElement resolved = ref.getReference().resolve();
                                        if (resolved == IntentionState.this.myReferee) {
                                            references.add(ref.getReference());
                                        }
                                    } else {
                                        IntentionState.this.myHasModuleReference = true;
                                    }
                                }
                            }
                            return true;
                        }
                    });
                    this.myReferences = references;
                }
            }
        }

        public void invoke() {
            assert (this.myImportElement != null) : "isAvailable() must have returned true, but myImportElement is null";
            PyUtil.sure(this.myImportElement.getImportReferenceExpression());
            Project project = this.myImportElement.getProject();
            PyElementGenerator generator = PyElementGenerator.getInstance(project);
            LanguageLevel languageLevel = LanguageLevel.forElement(this.myImportElement);
            try {
                PyImportElement[] importElements;
                StubBasedPsiElement<PyImportStatementStub> importStatement;
                HashSet usedNames = new HashSet();
                for (PsiReference ref : this.myReferences) {
                    PsiElement elt = ref.getElement();
                    PsiElement parentElt = elt.getParent();
                    String nameUsed = PyUtil.sure(PyUtil.sure(parentElt).getLastChild()).getText();
                    usedNames.add(nameUsed);
                    if (!FileModificationService.getInstance().preparePsiElementForWrite(elt)) {
                        return;
                    }
                    assert (parentElt instanceof PyReferenceExpression);
                    PyExpression newReference = generator.createExpressionFromText(languageLevel, nameUsed);
                    parentElt.replace((PsiElement)newReference);
                }
                PsiElement importer = this.myImportElement.getParent();
                if (importer instanceof PyImportStatement) {
                    importStatement = (PyImportStatement)importer;
                    importElements = importStatement.getImportElements();
                } else if (importer instanceof PyFromImportStatement) {
                    importStatement = (PyFromImportStatement)importer;
                    importElements = ((PyFromImportStatement)importStatement).getImportElements();
                } else {
                    throw new IncorrectOperationException("Not an import at all");
                }
                PyFromImportStatement newImportStatement = generator.createFromImportStatement(languageLevel, this.getDots() + this.myModuleName, StringUtil.join((Collection)usedNames, (String)", "), null);
                PsiElement parent = importStatement.getParent();
                PyUtil.sure(parent);
                PyUtil.sure(parent.isValid());
                if (importElements.length == 1) {
                    if (this.myHasModuleReference) {
                        parent.addAfter((PsiElement)newImportStatement, (PsiElement)importStatement);
                    } else {
                        PyUtil.sure(parent.getNode()).replaceChild(PyUtil.sure(importStatement.getNode()), PyUtil.sure(newImportStatement.getNode()));
                    }
                } else {
                    if (!this.myHasModuleReference) {
                        for (PyImportElement pie : importElements) {
                            if (pie != this.myImportElement) continue;
                            PyUtil.removeListNode(pie);
                            break;
                        }
                    }
                    parent.addAfter((PsiElement)newImportStatement, (PsiElement)importStatement);
                }
            }
            catch (IncorrectOperationException ignored) {
                PyUtil.showBalloon(project, PyBundle.message("QFIX.action.failed", new Object[0]), MessageType.WARNING);
            }
        }

        @NotNull
        public String getText() {
            PyReferenceExpression reference;
            String moduleName = "?";
            if (this.myImportElement != null && (reference = this.myImportElement.getImportReferenceExpression()) != null) {
                moduleName = PyPsiUtils.toPath(reference);
            }
            String string = PyBundle.message("INTN.convert.to.from.$0.import.$1", this.getDots() + moduleName, "...");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention$IntentionState", "getText"));
            }
            return string;
        }

        @NotNull
        private String getDots() {
            String dots = "";
            for (int i = 0; i < this.myRelativeLevel; ++i) {
                dots = dots + ".";
            }
            String string = dots;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/ImportToImportFromIntention$IntentionState", "getDots"));
            }
            return string;
        }
    }
}

