/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.intentions.NameUsage;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.ResolveProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclarationConflictChecker {
    private DeclarationConflictChecker() {
    }

    @NotNull
    public static List<Pair<PsiElement, PsiElement>> findDefinitions(String name, Collection<? extends PsiReference> references, @Nullable Collection<? extends PsiElement> ignored) {
        ArrayList<Pair<PsiElement, PsiElement>> conflicts = new ArrayList<Pair<PsiElement, PsiElement>>();
        block0: for (PsiReference psiReference : references) {
            ResolveProcessor processor = new ResolveProcessor(name);
            PyResolveUtil.treeCrawlUp(processor, psiReference.getElement());
            PsiElement result = processor.getResult();
            if (result == null) continue;
            List<PsiElement> definers = processor.getDefiners();
            if (definers != null && definers.size() > 0) {
                result = definers.get(0);
            }
            if (ignored != null) {
                for (PsiElement psiElement : ignored) {
                    if (result != psiElement) continue;
                    continue block0;
                }
            }
            conflicts.add((Pair<PsiElement, PsiElement>)Pair.create((Object)psiReference.getElement(), (Object)result));
        }
        ArrayList<Pair<PsiElement, PsiElement>> arrayList = conflicts;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/DeclarationConflictChecker", "findDefinitions"));
        }
        return arrayList;
    }

    public static boolean showConflicts(Project project, List<Pair<PsiElement, PsiElement>> conflicts, String obscured, @Nullable String name) {
        if (conflicts.size() > 0) {
            Usage[] usages = new Usage[conflicts.size()];
            int i = 0;
            for (Pair<PsiElement, PsiElement> pair : conflicts) {
                usages[i] = new NameUsage((PsiElement)pair.getFirst(), (PsiElement)pair.getSecond(), name != null ? name : obscured, name != null);
                ++i;
            }
            UsageViewPresentation prsnt = new UsageViewPresentation();
            prsnt.setTabText(PyBundle.message("CONFLICT.name.$0.obscured", obscured));
            prsnt.setCodeUsagesString(PyBundle.message("CONFLICT.name.$0.obscured.cannot.convert", obscured));
            prsnt.setUsagesWord(PyBundle.message("CONFLICT.occurrence.sing", new Object[0]));
            prsnt.setUsagesString(PyBundle.message("CONFLICT.occurrence.pl", new Object[0]));
            UsageViewManager.getInstance((Project)project).showUsages(UsageTarget.EMPTY_ARRAY, usages, prsnt);
            return true;
        }
        return false;
    }
}

