/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertVariadicParamIntention
extends BaseIntentionAction {
    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.convert.variadic.param", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/ConvertVariadicParamIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.convert.variadic.param", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/ConvertVariadicParamIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/ConvertVariadicParamIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyFunction.class);
        if (function != null) {
            PyParameter[] parameterList;
            for (PyParameter parameter : parameterList = function.getParameterList().getParameters()) {
                if (!(parameter instanceof PyNamedParameter) || !((PyNamedParameter)parameter).isKeywordContainer()) continue;
                List<PySubscriptionExpression> subscriptions = ConvertVariadicParamIntention.fillSubscriptions(function);
                List<PyCallExpression> callElements = ConvertVariadicParamIntention.fillCallExpressions(function);
                if (subscriptions.size() + callElements.size() != 0) {
                    for (PyCallExpression element : callElements) {
                        PyExpression[] arguments = element.getArguments();
                        if (arguments.length < 1) {
                            return false;
                        }
                        if (PyNames.isIdentifierString(PythonStringUtil.getStringValue((PsiElement)arguments[0]))) continue;
                        return false;
                    }
                    for (PySubscriptionExpression subscription : subscriptions) {
                        PyExpression expression = subscription.getIndexExpression();
                        if (PyNames.isIdentifierString(PythonStringUtil.getStringValue((PsiElement)expression))) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PyParameter getKeywordContainer(PyFunction function) {
        if (function != null) {
            PyParameter[] parameterList;
            for (PyParameter parameter : parameterList = function.getParameterList().getParameters()) {
                if (!(parameter instanceof PyNamedParameter) || !((PyNamedParameter)parameter).isKeywordContainer()) continue;
                return parameter;
            }
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/ConvertVariadicParamIntention", "invoke"));
        }
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyFunction.class);
        ConvertVariadicParamIntention.replaceSubscriptions(function, project);
        ConvertVariadicParamIntention.replaceCallElements(function, project);
    }

    private static List<PySubscriptionExpression> fillSubscriptions(PyFunction function) {
        ArrayList<PySubscriptionExpression> subscriptions = new ArrayList<PySubscriptionExpression>();
        PyStatementList statementList = function.getStatementList();
        Stack stack = new Stack();
        PyParameter keywordContainer = ConvertVariadicParamIntention.getKeywordContainer(function);
        if (keywordContainer != null) {
            String keywordContainerName = keywordContainer.getName();
            for (PyStatement st : statementList.getStatements()) {
                stack.push((Object)st);
                while (!stack.isEmpty()) {
                    PsiElement e = (PsiElement)stack.pop();
                    if (e instanceof PySubscriptionExpression) {
                        if (!((PySubscriptionExpression)e).getOperand().getText().equals(keywordContainerName)) continue;
                        subscriptions.add((PySubscriptionExpression)e);
                        continue;
                    }
                    for (PsiElement psiElement : e.getChildren()) {
                        stack.push((Object)psiElement);
                    }
                }
            }
        }
        return subscriptions;
    }

    private static boolean isCallElement(PyExpression callee, String keywordContainerName) {
        PyExpression qualifier = ((PyQualifiedExpression)callee).getQualifier();
        return qualifier != null && qualifier.getText().equals(keywordContainerName) && ("get".equals(((PyQualifiedExpression)callee).getReferencedName()) || "__getitem__".equals(((PyQualifiedExpression)callee).getReferencedName()));
    }

    private static List<PyCallExpression> fillCallExpressions(PyFunction function) {
        ArrayList<PyCallExpression> callElements = new ArrayList<PyCallExpression>();
        PyStatementList statementList = function.getStatementList();
        Stack stack = new Stack();
        PyParameter keywordContainer = ConvertVariadicParamIntention.getKeywordContainer(function);
        if (keywordContainer != null) {
            String keywordContainerName = keywordContainer.getName();
            for (PyStatement st : statementList.getStatements()) {
                stack.push((Object)st);
                while (!stack.isEmpty()) {
                    PsiElement e = (PsiElement)stack.pop();
                    if (e instanceof PySubscriptionExpression) continue;
                    if (e instanceof PyCallExpression && ((PyCallExpression)e).getCallee() instanceof PyQualifiedExpression && ConvertVariadicParamIntention.isCallElement(((PyCallExpression)e).getCallee(), keywordContainerName)) {
                        callElements.add((PyCallExpression)e);
                        continue;
                    }
                    for (PsiElement psiElement : e.getChildren()) {
                        stack.push((Object)psiElement);
                    }
                }
            }
        }
        return callElements;
    }

    private static void replaceSubscriptions(PyFunction function, Project project) {
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        List<PySubscriptionExpression> subscriptions = ConvertVariadicParamIntention.fillSubscriptions(function);
        int size = subscriptions.size();
        for (int i = 0; i != size; ++i) {
            PySubscriptionExpression subscriptionExpression = subscriptions.get(i);
            PyExpression indexExpression = subscriptionExpression.getIndexExpression();
            if (!(indexExpression instanceof PyStringLiteralExpression)) continue;
            PyExpression p = elementGenerator.createExpressionFromText(LanguageLevel.forElement(function), ((PyStringLiteralExpression)indexExpression).getStringValue());
            ASTNode comma = elementGenerator.createComma();
            PyClass containingClass = function.getContainingClass();
            if (p == null) continue;
            if (containingClass == null) {
                function.getParameterList().addBefore((PsiElement)p, (PsiElement)function.getParameterList().getParameters()[0]);
                function.getParameterList().addBefore((PsiElement)comma, (PsiElement)function.getParameterList().getParameters()[0]);
            } else {
                function.getParameterList().addBefore((PsiElement)p, (PsiElement)function.getParameterList().getParameters()[1]);
                function.getParameterList().addBefore((PsiElement)comma, (PsiElement)function.getParameterList().getParameters()[1]);
            }
            subscriptionExpression.replace((PsiElement)p);
        }
    }

    private static void replaceCallElements(PyFunction function, Project project) {
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        List<PyCallExpression> callElements = ConvertVariadicParamIntention.fillCallExpressions(function);
        int size = callElements.size();
        for (int i = 0; i != size; ++i) {
            PyExpression callee;
            PyCallExpression callExpression = callElements.get(i);
            PyExpression indexExpression = callExpression.getArguments()[0];
            if (!(indexExpression instanceof PyStringLiteralExpression)) continue;
            PyNamedParameter defaultValue = null;
            if (callExpression.getArguments().length > 1) {
                defaultValue = elementGenerator.createParameter(((PyStringLiteralExpression)indexExpression).getStringValue() + "=" + callExpression.getArguments()[1].getText());
            }
            if (defaultValue == null && (callee = callExpression.getCallee()) instanceof PyQualifiedExpression && "get".equals(((PyQualifiedExpression)callee).getReferencedName())) {
                defaultValue = elementGenerator.createParameter(((PyStringLiteralExpression)indexExpression).getStringValue() + "=None");
            }
            PyExpression p = elementGenerator.createExpressionFromText(LanguageLevel.forElement(function), ((PyStringLiteralExpression)indexExpression).getStringValue());
            ASTNode comma = elementGenerator.createComma();
            PyParameter keywordContainer = ConvertVariadicParamIntention.getKeywordContainer(function);
            if (p == null) continue;
            if (defaultValue != null) {
                function.getParameterList().addBefore((PsiElement)defaultValue, (PsiElement)keywordContainer);
            } else {
                function.getParameterList().addBefore((PsiElement)p, (PsiElement)keywordContainer);
            }
            function.getParameterList().addBefore((PsiElement)comma, (PsiElement)keywordContainer);
            callExpression.replace((PsiElement)p);
        }
    }
}

