/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ConvertFormatOperatorToMethodIntention
extends BaseIntentionAction {
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(?:\\((\\w+)\\))?([-#0+ ]*)((?:\\*|\\d+)?(?:\\.(?:\\*|\\d+))?)?[hlL]?([diouxXeEfFgGcrs%])");
    private static final Pattern BRACE_PATTERN = Pattern.compile("(\\{|\\})");

    private static void appendDoublingBraces(CharSequence source, StringBuilder target) {
        int index = 0;
        Matcher scanner = BRACE_PATTERN.matcher(source);
        boolean skipClosingBrace = false;
        while (scanner.find(index)) {
            if (scanner.start() > 1 && "{".equals(scanner.group(0)) && "\\N".equals(((Object)source.subSequence(scanner.start() - 2, scanner.start())).toString())) {
                skipClosingBrace = true;
                target.append(source.subSequence(index, scanner.end()));
                index = scanner.end();
                continue;
            }
            if (skipClosingBrace && "}".equals(scanner.group(0))) {
                skipClosingBrace = false;
                target.append(source.subSequence(index, scanner.end()));
                index = scanner.end();
                continue;
            }
            target.append(source.subSequence(index, scanner.start()));
            if ("{".equals(scanner.group(0))) {
                target.append("{{");
            } else {
                target.append("}}");
            }
            index = scanner.end();
        }
        target.append(source.subSequence(index, source.length()));
    }

    private static Pair<StringBuilder, Boolean> convertFormat(PyStringLiteralExpression stringLiteralExpression, String prefix) {
        int right;
        ArrayList<StringBuilder> constants = new ArrayList<StringBuilder>();
        boolean usesNamedFormat = false;
        List<ASTNode> stringNodes = stringLiteralExpression.getStringNodes();
        PyUtil.sure(stringNodes);
        PyUtil.sure(stringNodes.size() > 0);
        for (ASTNode stringNode : stringNodes) {
            char quote;
            CharSequence text = stringNode.getChars();
            int openPos = 0;
            boolean hasPrefix = false;
            int prefixLength = PyStringLiteralExpressionImpl.getPrefixLength(String.valueOf(text));
            if (prefixLength != 0) {
                hasPrefix = true;
            }
            PyUtil.sure("\"'".indexOf(quote = text.charAt(openPos += prefixLength)) >= 0);
            if (text.length() - openPos >= 6 && text.charAt(openPos + 1) == quote && text.charAt(openPos + 2) == quote) {
                openPos += 2;
            }
            int index = openPos + 1;
            StringBuilder out = new StringBuilder(text.subSequence(0, openPos + 1));
            if (!hasPrefix) {
                out.insert(0, prefix);
            }
            int position_count = 0;
            Matcher scanner = FORMAT_PATTERN.matcher(text);
            while (scanner.find(index)) {
                ConvertFormatOperatorToMethodIntention.appendDoublingBraces(text.subSequence(index, scanner.start()), out);
                String f_key = scanner.group(1);
                String f_modifier = scanner.group(2);
                String f_width = scanner.group(3);
                String f_conversion = scanner.group(4);
                if ("%%".equals(scanner.group(0))) {
                    out.append("%");
                } else {
                    PyUtil.sure(f_conversion);
                    PyUtil.sure(!"%".equals(f_conversion));
                    out.append("{");
                    if (f_key != null) {
                        out.append(f_key);
                        usesNamedFormat = true;
                    } else {
                        out.append(position_count);
                        ++position_count;
                    }
                    if ("r".equals(f_conversion)) {
                        out.append("!r");
                    }
                    out.append(":");
                    if (f_modifier != null) {
                        if (ConvertFormatOperatorToMethodIntention.has(f_modifier, '-')) {
                            out.append("<");
                        } else if ("s".equals(f_conversion) && !StringUtil.isEmptyOrSpaces((String)f_width)) {
                            out.append(">");
                        }
                        if (ConvertFormatOperatorToMethodIntention.has(f_modifier, '+')) {
                            out.append("+");
                        } else if (ConvertFormatOperatorToMethodIntention.has(f_modifier, ' ')) {
                            out.append(" ");
                        }
                        if (ConvertFormatOperatorToMethodIntention.has(f_modifier, '#')) {
                            out.append("#");
                        }
                        if (ConvertFormatOperatorToMethodIntention.has(f_modifier, '0')) {
                            out.append("0");
                        }
                    }
                    if (f_width != null) {
                        out.append(f_width);
                    }
                    if ("i".equals(f_conversion) || "u".equals(f_conversion)) {
                        out.append("d");
                    } else if ("r".equals(f_conversion)) {
                        out.append("s");
                    } else {
                        out.append(f_conversion);
                    }
                    out.append("}");
                }
                index = scanner.end();
            }
            ConvertFormatOperatorToMethodIntention.appendDoublingBraces(text.subSequence(index, text.length()), out);
            constants.add(out);
        }
        TextRange full_range = stringLiteralExpression.getTextRange();
        int full_start = full_range.getStartOffset();
        CharSequence full_text = stringLiteralExpression.getNode().getChars();
        TextRange prev_range = stringNodes.get(0).getTextRange();
        for (int fragment_no = 1; fragment_no < stringNodes.size(); ++fragment_no) {
            int right2;
            TextRange next_range = stringNodes.get(fragment_no).getTextRange();
            int left = prev_range.getEndOffset() - full_start;
            if (left < (right2 = next_range.getStartOffset() - full_start)) {
                ((StringBuilder)constants.get(fragment_no - 1)).append(full_text.subSequence(left, right2));
            }
            prev_range = next_range;
        }
        int left = prev_range.getEndOffset() - full_start;
        if (left < (right = full_range.getEndOffset() - full_start)) {
            ((StringBuilder)constants.get(constants.size() - 1)).append(full_text.subSequence(left, right));
        }
        StringBuilder result = new StringBuilder();
        for (StringBuilder one : constants) {
            result.append((CharSequence)one);
        }
        return new Pair((Object)result, (Object)usesNamedFormat);
    }

    private static boolean has(String where, char what) {
        return where.indexOf(what) >= 0;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.format.operator.to.method", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/ConvertFormatOperatorToMethodIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/ConvertFormatOperatorToMethodIntention", "isAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyBinaryExpression binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyBinaryExpression.class, (boolean)false);
        if (binaryExpression == null) {
            return false;
        }
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)binaryExpression);
        if (languageLevel.isOlderThan(LanguageLevel.PYTHON26)) {
            return false;
        }
        if (binaryExpression.getLeftExpression() instanceof PyStringLiteralExpression && binaryExpression.getOperator() == PyTokenTypes.PERC) {
            this.setText(PyBundle.message("INTN.replace.with.method", new Object[0]));
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/intentions/ConvertFormatOperatorToMethodIntention", "invoke"));
        }
        PsiElement elementAt = file.findElementAt(editor.getCaretModel().getOffset());
        PyBinaryExpression element = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyBinaryExpression.class, (boolean)false);
        if (element == null) {
            return;
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PyExpression rightExpression = PyUtil.sure(element).getRightExpression();
        if (rightExpression == null) {
            return;
        }
        PyExpression rhs = PyPsiUtils.flattenParens(rightExpression);
        if (rhs == null) {
            return;
        }
        String paramText = PyUtil.sure(rhs).getText();
        TypeEvalContext context = TypeEvalContext.userInitiated(file.getProject(), file);
        PyType rhsType = context.getType(rhs);
        String prefix = "";
        if (PyTypeChecker.match(PyBuiltinCache.getInstance((PsiElement)rhs).getObjectType("unicode"), rhsType, context)) {
            prefix = "u";
        }
        PyStringLiteralExpression leftExpression = (PyStringLiteralExpression)element.getLeftExpression();
        Pair<StringBuilder, Boolean> converted = ConvertFormatOperatorToMethodIntention.convertFormat(leftExpression, prefix);
        StringBuilder target = (StringBuilder)converted.getFirst();
        String separator = ConvertFormatOperatorToMethodIntention.getSeparator(leftExpression);
        target.append(separator).append(".format");
        if (rhs instanceof PyDictLiteralExpression) {
            target.append("(**").append(paramText).append(")");
        } else if (rhs instanceof PyCallExpression) {
            PsiElement maybeDict;
            PyCallExpression callExpression = (PyCallExpression)rhs;
            PyExpression callee = callExpression.getCallee();
            if (callee instanceof PyReferenceExpression && (maybeDict = ((PyReferenceExpression)callee).getReference().resolve()) instanceof PyFunction) {
                PyFunction dictInit = (PyFunction)maybeDict;
                if ("__init__".equals(dictInit.getName())) {
                    PyClassType dictType = PyBuiltinCache.getInstance((PsiElement)file).getDictType();
                    if (dictType != null && dictType.getPyClass() == dictInit.getContainingClass()) {
                        target.append(PyUtil.sure(PyUtil.sure(callExpression.getArgumentList()).getNode()).getChars());
                    }
                } else {
                    target.append("(");
                    if (((Boolean)converted.getSecond()).booleanValue()) {
                        target.append("**");
                    }
                    target.append(paramText).append(")");
                }
            }
        } else {
            target.append("(").append(paramText).append(")");
        }
        target.insert(0, '(').append(')');
        PyExpression parenthesized = elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)element), target.toString());
        element.replace((PsiElement)PyUtil.sure(((PyParenthesizedExpression)parenthesized).getContainedExpression()));
    }

    private static String getSeparator(PyStringLiteralExpression leftExpression) {
        String separator = "";
        Pair<String, PsiElement> crop = ConvertFormatOperatorToMethodIntention.collectWhitespace(leftExpression);
        String maybeSeparator = (String)crop.getFirst();
        if (maybeSeparator != null && !maybeSeparator.isEmpty() && !" ".equals(maybeSeparator)) {
            separator = maybeSeparator;
        } else {
            maybeSeparator = (String)(crop = ConvertFormatOperatorToMethodIntention.collectWhitespace((PsiElement)crop.getSecond())).getFirst();
            if (maybeSeparator != null && !maybeSeparator.isEmpty() && !" ".equals(maybeSeparator)) {
                separator = maybeSeparator;
            }
        }
        return separator;
    }

    private static Pair<String, PsiElement> collectWhitespace(PsiElement start) {
        StringBuilder sb = new StringBuilder();
        PsiElement seeker = start;
        while (seeker != null && (seeker = seeker.getNextSibling()) != null && seeker instanceof PsiWhiteSpace) {
            sb.append(seeker.getText());
        }
        return Pair.create((Object)sb.toString(), (Object)seeker);
    }
}

