/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.imports.AutoImportQuickFix;
import com.jetbrains.python.codeInsight.imports.ImportFromExistingAction;
import com.jetbrains.python.codeInsight.imports.PyImportCandidateProvider;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFileImpl;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.stubs.PyVariableNameIndex;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonReferenceImporter
implements ReferenceImporter {
    @Override
    public boolean autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/imports/PythonReferenceImporter", "autoImportReferenceAtCursor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/imports/PythonReferenceImporter", "autoImportReferenceAtCursor"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(caretOffset);
        int startOffset = document.getLineStartOffset(lineNumber);
        int endOffset = document.getLineEndOffset(lineNumber);
        List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange((PsiElement)file, startOffset, endOffset);
        for (PsiElement element : elements) {
            PsiPolyVariantReference reference;
            PyReferenceExpression refExpr;
            if (!(element instanceof PyReferenceExpression) || !PythonReferenceImporter.isImportable(element) || (refExpr = (PyReferenceExpression)element).isQualified() || (reference = refExpr.getReference()).resolve() != null) continue;
            AutoImportQuickFix fix = PythonReferenceImporter.proposeImportFix(refExpr, (PsiReference)reference);
            if (fix != null && fix.getCandidatesCount() == 1) {
                fix.invoke(file);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean autoImportReferenceAt(@NotNull Editor editor, @NotNull PsiFile file, int offset) {
        PsiPolyVariantReference reference;
        PyReferenceExpression refExpr;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/imports/PythonReferenceImporter", "autoImportReferenceAt"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/imports/PythonReferenceImporter", "autoImportReferenceAt"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PsiReference element = file.findReferenceAt(offset);
        if (element instanceof PyReferenceExpression && PythonReferenceImporter.isImportable((PsiElement)element) && !(refExpr = (PyReferenceExpression)element).isQualified() && (reference = refExpr.getReference()).resolve() == null) {
            AutoImportQuickFix fix = PythonReferenceImporter.proposeImportFix(refExpr, (PsiReference)reference);
            if (fix != null && fix.getCandidatesCount() == 1) {
                fix.invoke(file);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static AutoImportQuickFix proposeImportFix(PyElement node, PsiReference reference) {
        String text = reference.getElement().getText();
        String refText = reference.getRangeInElement().substring(text);
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)node);
        if (module != null && PythonSdkType.findPythonSdk(module) == null) {
            return null;
        }
        ScopeOwner scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)node, ScopeOwner.class);
        if (scopeOwner != null && ControlFlowCache.getScope(scopeOwner).containsDeclaration(refText)) {
            return null;
        }
        AutoImportQuickFix fix = new AutoImportQuickFix(node, reference, !PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT);
        HashSet<String> seenFileNames = new HashSet<String>();
        PsiFile existingImportFile = PythonReferenceImporter.addCandidatesFromExistingImports(node, refText, fix, seenFileNames);
        if (fix.getCandidatesCount() == 0 || fix.hasProjectImports() || Registry.is((String)"python.import.always.ask")) {
            ProgressManager.checkCanceled();
            PythonReferenceImporter.addSymbolImportCandidates(node, refText, fix, seenFileNames, existingImportFile);
        }
        for (PyImportCandidateProvider provider : (PyImportCandidateProvider[])Extensions.getExtensions(PyImportCandidateProvider.EP_NAME)) {
            provider.addImportCandidates(reference, refText, fix);
        }
        if (fix.getCandidatesCount() > 0) {
            fix.sortCandidates();
            return fix;
        }
        return null;
    }

    @Nullable
    private static PsiFile addCandidatesFromExistingImports(PyElement node, String refText, AutoImportQuickFix fix, Set<String> seenFileNames) {
        PsiFile existingImportFile = null;
        PsiFile file = node.getContainingFile();
        if (file instanceof PyFile) {
            PyFile pyFile = (PyFile)file;
            for (PyImportElement importElement : pyFile.getImportTargets()) {
                existingImportFile = PythonReferenceImporter.addImportViaElement(refText, fix, seenFileNames, existingImportFile, importElement, importElement.resolve());
            }
            for (PyFromImportStatement fromImportStatement : pyFile.getFromImports()) {
                if (fromImportStatement.isStarImport() || fromImportStatement.getImportElements().length <= 0) continue;
                PsiElement source = fromImportStatement.resolveImportSource();
                existingImportFile = PythonReferenceImporter.addImportViaElement(refText, fix, seenFileNames, existingImportFile, fromImportStatement.getImportElements()[0], source);
            }
        }
        return existingImportFile;
    }

    private static PsiFile addImportViaElement(String refText, AutoImportQuickFix fix, Set<String> seenFileNames, PsiFile existingImportFile, PyImportElement importElement, PsiElement source) {
        PsiElement sourceFile = PyUtil.turnDirIntoInit(source);
        if (sourceFile instanceof PyFileImpl) {
            PyFileImpl importSourceFile;
            PsiElement res;
            PyStatement importStatement = importElement.getContainingImportStatement();
            String refName = null;
            if (importStatement instanceof PyFromImportStatement) {
                QualifiedName qName = ((PyFromImportStatement)importStatement).getImportSourceQName();
                if (qName != null) {
                    refName = qName.toString();
                }
            } else {
                QualifiedName importReferenceQName = importElement.getImportedQName();
                if (importReferenceQName != null) {
                    refName = importReferenceQName.toString();
                }
            }
            if (refName != null) {
                if (seenFileNames.contains(refName)) {
                    return existingImportFile;
                }
                seenFileNames.add(refName);
            }
            if ((res = (importSourceFile = (PyFileImpl)sourceFile).findExportedName(refText)) != null && !(res instanceof PyFile) && !(res instanceof PyImportElement) && res.getContainingFile() != null && PsiTreeUtil.isAncestor((PsiElement)source, (PsiElement)res.getContainingFile(), (boolean)false)) {
                existingImportFile = importSourceFile;
                fix.addImport(res, importSourceFile, importElement);
            }
        }
        return existingImportFile;
    }

    private static void addSymbolImportCandidates(PyElement node, String refText, AutoImportQuickFix fix, Set<String> seenFileNames, PsiFile existingImportFile) {
        Project project = node.getProject();
        ArrayList<Object> symbols = new ArrayList<Object>();
        symbols.addAll(PyClassNameIndex.find(refText, project, true));
        GlobalSearchScope scope = PyProjectScopeBuilder.excludeSdkTestsScope((PsiElement)node);
        if (!PythonReferenceImporter.isQualifier(node)) {
            symbols.addAll(PyFunctionNameIndex.find(refText, project, scope));
        }
        symbols.addAll(PyVariableNameIndex.find(refText, project, scope));
        if (PythonReferenceImporter.isPossibleModuleReference(node)) {
            symbols.addAll(PythonReferenceImporter.findImportableModules(node.getContainingFile(), refText, project, scope));
        }
        if (!symbols.isEmpty()) {
            for (PsiElement psiElement : symbols) {
                PsiFile srcfile;
                if (!PythonReferenceImporter.isIndexableTopLevel(psiElement) || (srcfile = psiElement instanceof PsiFileSystemItem ? ((PsiFileSystemItem)psiElement).getParent() : psiElement.getContainingFile()) == null || !PythonReferenceImporter.isAcceptableForImport(node, existingImportFile, (PsiFileSystemItem)srcfile)) continue;
                QualifiedName importPath = QualifiedNameFinder.findCanonicalImportPath(psiElement, (PsiElement)node);
                if (psiElement instanceof PsiFileSystemItem && importPath != null) {
                    importPath = importPath.removeTail(1);
                }
                if (importPath == null || seenFileNames.contains(importPath.toString())) continue;
                fix.addImport(psiElement, (PsiFileSystemItem)srcfile, importPath);
                seenFileNames.add(importPath.toString());
            }
        }
    }

    private static boolean isAcceptableForImport(PyElement node, PsiFile existingImportFile, PsiFileSystemItem srcfile) {
        return srcfile != existingImportFile && srcfile != node.getContainingFile() && (ImportFromExistingAction.isRoot(srcfile) || PyNames.isIdentifier(FileUtil.getNameWithoutExtension((String)srcfile.getName()))) && !PythonReferenceImporter.isShadowedModule(srcfile);
    }

    private static boolean isShadowedModule(PsiFileSystemItem file) {
        if (file.isDirectory() || file.getName().equals("__init__.py")) {
            return false;
        }
        String name = FileUtil.getNameWithoutExtension((String)file.getName());
        PsiDirectory directory = ((PsiFile)file).getContainingDirectory();
        if (directory == null) {
            return false;
        }
        PsiDirectory packageDir = directory.findSubdirectory(name);
        return packageDir != null && packageDir.findFile("__init__.py") != null;
    }

    private static boolean isQualifier(PyElement node) {
        return node.getParent() instanceof PyReferenceExpression && node == ((PyReferenceExpression)node.getParent()).getQualifier();
    }

    private static boolean isPossibleModuleReference(PyElement node) {
        PyClass pyClass;
        PyArgumentList argumentList;
        if (node.getParent() instanceof PyCallExpression && node == ((PyCallExpression)node.getParent()).getCallee()) {
            return false;
        }
        return !(node.getParent() instanceof PyArgumentList) || !((argumentList = (PyArgumentList)node.getParent()).getParent() instanceof PyClass) || (pyClass = (PyClass)argumentList.getParent()).getSuperClassExpressionList() != argumentList;
    }

    private static Collection<PsiElement> findImportableModules(PsiFile targetFile, String reftext, Project project, GlobalSearchScope scope) {
        PsiFile[] initFiles;
        PsiFile[] files;
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiFile file : files = FilenameIndex.getFilesByName(project, reftext + ".py", scope)) {
            if (!PythonReferenceImporter.isImportableModule(targetFile, (PsiFileSystemItem)file)) continue;
            result.add((PsiElement)file);
        }
        for (PsiFile initFile : initFiles = FilenameIndex.getFilesByName(project, "__init__.py", scope)) {
            PsiDirectory parent = initFile.getParent();
            if (parent == null || !parent.getName().equals(reftext)) continue;
            result.add((PsiElement)parent);
        }
        return result;
    }

    public static boolean isImportableModule(PsiFile targetFile, @NotNull PsiFileSystemItem file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/imports/PythonReferenceImporter", "isImportableModule"));
        }
        PsiDirectory parent = (PsiDirectory)file.getParent();
        return parent != null && file != targetFile && (parent.findFile("__init__.py") != null || ImportFromExistingAction.isRoot((PsiFileSystemItem)parent) || parent == targetFile.getParent());
    }

    private static boolean isIndexableTopLevel(PsiElement symbol) {
        if (symbol instanceof PsiFileSystemItem) {
            return true;
        }
        if (symbol instanceof PyClass || symbol instanceof PyFunction) {
            return PyUtil.isTopLevel(symbol);
        }
        return symbol instanceof PyTargetExpression;
    }

    public static boolean isImportable(PsiElement ref_element) {
        PyStatement parentStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)ref_element, PyStatement.class);
        if (parentStatement instanceof PyGlobalStatement || parentStatement instanceof PyNonlocalStatement || parentStatement instanceof PyImportStatementBase) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)ref_element, PyStringLiteralExpression.class, (boolean)false, (Class[])new Class[]{PyStatement.class}) == null;
    }
}

