/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.lang.ImportOptimizer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.formatter.PyBlock;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyImportOptimizer
implements ImportOptimizer {
    public boolean supports(PsiFile file) {
        return true;
    }

    @NotNull
    public Runnable processFile(final @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/imports/PyImportOptimizer", "processFile"));
        }
        LocalInspectionToolSession session = new LocalInspectionToolSession(file, 0, file.getTextLength());
        final PyUnresolvedReferencesInspection.Visitor visitor = new PyUnresolvedReferencesInspection.Visitor(null, session, Collections.<String>emptyList());
        file.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyElement(PyElement node) {
                super.visitPyElement(node);
                node.accept(visitor);
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                visitor.optimizeImports();
                if (file instanceof PyFile) {
                    new ImportSorter((PyFile)file).run();
                }
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/PyImportOptimizer", "processFile"));
        }
        return runnable;
    }

    private static class ImportSorter {
        private final PyFile myFile;
        private final List<PyImportStatementBase> myBuiltinImports = new ArrayList<PyImportStatementBase>();
        private final List<PyImportStatementBase> myThirdPartyImports = new ArrayList<PyImportStatementBase>();
        private final List<PyImportStatementBase> myProjectImports = new ArrayList<PyImportStatementBase>();
        private final List<PyImportStatementBase> myImportBlock;
        private final PyElementGenerator myGenerator;
        private boolean myMissorted = false;

        private ImportSorter(PyFile file) {
            this.myFile = file;
            this.myImportBlock = this.myFile.getImportBlock();
            this.myGenerator = PyElementGenerator.getInstance(this.myFile.getProject());
        }

        public void run() {
            if (this.myImportBlock.isEmpty()) {
                return;
            }
            LanguageLevel langLevel = LanguageLevel.forElement(this.myFile);
            for (PyImportStatementBase importStatement : this.myImportBlock) {
                PyImportElement firstImportElement;
                if (importStatement instanceof PyFromImportStatement && ((PyFromImportStatement)importStatement).isFromFuture()) continue;
                if (importStatement instanceof PyImportStatement && importStatement.getImportElements().length > 1) {
                    for (PyImportElement importElement : importStatement.getImportElements()) {
                        this.myMissorted = true;
                        PsiElement toImport = importElement.resolve();
                        PyImportStatement splitImport = this.myGenerator.createImportStatement(langLevel, importElement.getText(), null);
                        this.prioritize(splitImport, toImport);
                    }
                    continue;
                }
                PsiElement toImport = importStatement instanceof PyFromImportStatement ? ((PyFromImportStatement)importStatement).resolveImportSource() : ((firstImportElement = (PyImportElement)ArrayUtil.getFirstElement((Object[])importStatement.getImportElements())) != null ? firstImportElement.resolve() : null);
                this.prioritize(importStatement, toImport);
            }
            if (this.myMissorted || this.needBlankLinesBetweenGroups()) {
                this.applyResults();
            }
        }

        private boolean needBlankLinesBetweenGroups() {
            int nonEmptyGroups = 0;
            if (this.myBuiltinImports.size() > 0) {
                ++nonEmptyGroups;
            }
            if (this.myThirdPartyImports.size() > 0) {
                ++nonEmptyGroups;
            }
            if (this.myProjectImports.size() > 0) {
                ++nonEmptyGroups;
            }
            return nonEmptyGroups > 1;
        }

        private void prioritize(PyImportStatementBase importStatement, @Nullable PsiElement toImport) {
            AddImportHelper.ImportPriority priority;
            if (toImport != null && !(toImport instanceof PsiFileSystemItem)) {
                toImport = toImport.getContainingFile();
            }
            AddImportHelper.ImportPriority importPriority = priority = toImport == null ? AddImportHelper.ImportPriority.PROJECT : AddImportHelper.getImportPriority(this.myFile, (PsiFileSystemItem)toImport);
            if (priority == AddImportHelper.ImportPriority.BUILTIN) {
                this.myBuiltinImports.add(importStatement);
                if (!this.myThirdPartyImports.isEmpty() || !this.myProjectImports.isEmpty()) {
                    this.myMissorted = true;
                }
            } else if (priority == AddImportHelper.ImportPriority.THIRD_PARTY) {
                this.myThirdPartyImports.add(importStatement);
                if (!this.myProjectImports.isEmpty()) {
                    this.myMissorted = true;
                }
            } else {
                this.myProjectImports.add(importStatement);
            }
        }

        private void applyResults() {
            ImportSorter.markGroupBegin(this.myThirdPartyImports);
            ImportSorter.markGroupBegin(this.myProjectImports);
            this.addImports(this.myBuiltinImports);
            this.addImports(this.myThirdPartyImports);
            this.addImports(this.myProjectImports);
            PsiElement lastElement = (PsiElement)this.myImportBlock.get(this.myImportBlock.size() - 1);
            PyImportStatementBase firstNonFutureImport = this.findFirstNonFutureImport();
            if (firstNonFutureImport != null) {
                this.myFile.deleteChildRange((PsiElement)firstNonFutureImport, lastElement);
            }
            for (PyImportStatementBase anImport : this.myBuiltinImports) {
                anImport.putCopyableUserData(PyBlock.IMPORT_GROUP_BEGIN, null);
            }
        }

        private PyImportStatementBase findFirstNonFutureImport() {
            for (PyImportStatementBase importStatement : this.myImportBlock) {
                if (importStatement instanceof PyFromImportStatement && ((PyFromImportStatement)importStatement).isFromFuture()) continue;
                return importStatement;
            }
            return null;
        }

        private static void markGroupBegin(List<PyImportStatementBase> imports) {
            if (imports.size() > 0) {
                imports.get(0).putCopyableUserData(PyBlock.IMPORT_GROUP_BEGIN, true);
            }
        }

        private void addImports(List<PyImportStatementBase> imports) {
            for (PyImportStatementBase newImport : imports) {
                this.myFile.addBefore((PsiElement)newImport, (PsiElement)this.findFirstNonFutureImport());
            }
        }
    }
}

