/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.codeInsight.imports.PyImportOptimizer;
import com.jetbrains.python.psi.PyFile;
import org.jetbrains.annotations.NotNull;

public class OptimizeImportsQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    @NotNull
    public String getName() {
        if ("Optimize imports" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/OptimizeImportsQuickFix", "getName"));
        }
        return "Optimize imports";
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/OptimizeImportsQuickFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Optimize imports" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/OptimizeImportsQuickFix", "getFamilyName"));
        }
        return "Optimize imports";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/imports/OptimizeImportsQuickFix", "isAvailable"));
        }
        return file instanceof PyFile;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/imports/OptimizeImportsQuickFix", "invoke"));
        }
        this.optimizeImports(project, file);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/imports/OptimizeImportsQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/codeInsight/imports/OptimizeImportsQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return;
        }
        PsiFile file = element.getContainingFile();
        this.optimizeImports(project, file);
    }

    private void optimizeImports(Project project, PsiFile file) {
        PyImportOptimizer optimizer = new PyImportOptimizer();
        final Runnable runnable = optimizer.processFile(file);
        new WriteCommandAction.Simple(project, this.getFamilyName(), new PsiFile[]{file}){

            protected void run() throws Throwable {
                runnable.run();
            }
        }.execute();
    }
}

