/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.imports.ImportCandidateHolder;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ImportFromExistingAction
implements QuestionAction {
    PyElement myTarget;
    List<ImportCandidateHolder> mySources;
    String myName;
    boolean myUseQualifiedImport;
    private Runnable myOnDoneCallback;
    private final boolean myImportLocally;

    public ImportFromExistingAction(@NotNull PyElement target, @NotNull List<ImportCandidateHolder> sources, @NotNull String name, boolean useQualified, boolean importLocally) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/python/codeInsight/imports/ImportFromExistingAction", "<init>"));
        }
        if (sources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sources", "com/jetbrains/python/codeInsight/imports/ImportFromExistingAction", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/imports/ImportFromExistingAction", "<init>"));
        }
        this.myTarget = target;
        this.mySources = sources;
        this.myName = name;
        this.myUseQualifiedImport = useQualified;
        this.myImportLocally = importLocally;
    }

    public void onDone(Runnable callback) {
        assert (this.myOnDoneCallback == null);
        this.myOnDoneCallback = callback;
    }

    public boolean execute() {
        PsiDocumentManager.getInstance((Project)this.myTarget.getProject()).commitAllDocuments();
        if (!this.myTarget.isValid()) {
            return false;
        }
        if (this.myTarget instanceof PyQualifiedExpression && ((PyQualifiedExpression)this.myTarget).isQualified()) {
            return false;
        }
        for (ImportCandidateHolder item : this.mySources) {
            if (!item.getImportable().isValid()) {
                return false;
            }
            if (!item.getFile().isValid()) {
                return false;
            }
            if (item.getImportElement() == null || item.getImportElement().isValid()) continue;
            return false;
        }
        if (this.mySources.isEmpty()) {
            return false;
        }
        if (this.mySources.size() > 1) {
            this.selectSourceAndDo();
        } else {
            this.doWriteAction(this.mySources.get(0));
        }
        return true;
    }

    private void selectSourceAndDo() {
        Object[] items = this.mySources.toArray(new ImportCandidateHolder[this.mySources.size()]);
        JBList list = new JBList(items);
        list.setCellRenderer(new CellRenderer(this.myName));
        Runnable runnable = new Runnable((JList)list){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            @Override
            public void run() {
                Object selected = this.val$list.getSelectedValue();
                if (selected instanceof ImportCandidateHolder) {
                    ImportCandidateHolder item = (ImportCandidateHolder)selected;
                    PsiDocumentManager.getInstance((Project)ImportFromExistingAction.this.myTarget.getProject()).commitAllDocuments();
                    ImportFromExistingAction.this.doWriteAction(item);
                }
            }
        };
        DataManager.getInstance().getDataContextFromFocus().doWhenDone((Consumer)new Consumer<DataContext>((JList)list, runnable){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Runnable val$runnable;
            {
                this.val$list = jList;
                this.val$runnable = runnable;
            }

            public void consume(DataContext dataContext) {
                new PopupChooserBuilder(this.val$list).setTitle(ImportFromExistingAction.this.myUseQualifiedImport ? PyBundle.message("ACT.qualify.with.module", new Object[0]) : PyBundle.message("ACT.from.some.module.import", new Object[0])).setItemChoosenCallback(this.val$runnable).setFilteringEnabled((Function)new Function<Object, String>(){

                    public String fun(Object o) {
                        return ((ImportCandidateHolder)o).getPresentableText(ImportFromExistingAction.this.myName);
                    }
                }).createPopup().showInBestPositionFor(dataContext);
            }
        });
    }

    private void doIt(ImportCandidateHolder item) {
        PyImportElement src = item.getImportElement();
        if (src != null) {
            this.addToExistingImport(src);
        } else {
            this.addImportStatement(item);
        }
    }

    private void addImportStatement(ImportCandidateHolder item) {
        Project project = this.myTarget.getProject();
        PyElementGenerator gen = PyElementGenerator.getInstance(project);
        AddImportHelper.ImportPriority priority = AddImportHelper.getImportPriority((PsiElement)this.myTarget, item.getFile());
        PsiFile file = this.myTarget.getContainingFile();
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)project);
        if (manager.isInjectedFragment(file)) {
            file = manager.getTopLevelFile((PsiElement)this.myTarget);
        }
        if (ImportFromExistingAction.isRoot(item.getFile())) {
            if (this.myImportLocally) {
                AddImportHelper.addLocalImportStatement(this.myTarget, this.myName);
            } else {
                AddImportHelper.addImportStatement(file, this.myName, null, priority, null);
            }
        } else {
            String qualifiedName = item.getPath().toString();
            if (this.myUseQualifiedImport) {
                String nameToImport = qualifiedName;
                if (item.getImportable() instanceof PsiFileSystemItem) {
                    nameToImport = nameToImport + "." + this.myName;
                }
                if (this.myImportLocally) {
                    AddImportHelper.addLocalImportStatement(this.myTarget, nameToImport);
                } else {
                    AddImportHelper.addImportStatement(file, nameToImport, null, priority, null);
                }
                this.myTarget.replace((PsiElement)gen.createExpressionFromText(LanguageLevel.forElement((PsiElement)this.myTarget), qualifiedName + "." + this.myName));
            } else if (this.myImportLocally) {
                AddImportHelper.addLocalFromImportStatement(this.myTarget, qualifiedName, this.myName);
            } else {
                AddImportHelper.addFromImportStatement(file, qualifiedName, this.myName, null, priority, null);
            }
        }
    }

    private void addToExistingImport(PyImportElement src) {
        PyElementGenerator gen = PyElementGenerator.getInstance(this.myTarget.getProject());
        PsiElement parent = src.getParent();
        if (parent instanceof PyFromImportStatement) {
            PyImportElement newImportElement = gen.createImportElement(LanguageLevel.getDefault(), this.myName);
            parent.add((PsiElement)newImportElement);
        } else {
            this.myTarget.replace((PsiElement)gen.createExpressionFromText(LanguageLevel.forElement((PsiElement)this.myTarget), src.getVisibleName() + "." + this.myName));
        }
    }

    private void doWriteAction(final ImportCandidateHolder item) {
        PsiElement src = item.getImportable();
        new WriteCommandAction(src.getProject(), PyBundle.message("ACT.CMD.use.import", new Object[0]), new PsiFile[]{this.myTarget.getContainingFile()}){

            protected void run(Result result) throws Throwable {
                ImportFromExistingAction.this.doIt(item);
            }
        }.execute();
        if (this.myOnDoneCallback != null) {
            this.myOnDoneCallback.run();
        }
    }

    public static boolean isRoot(PsiFileSystemItem directory) {
        if (directory == null) {
            return true;
        }
        VirtualFile vFile = directory.getVirtualFile();
        if (vFile == null) {
            return true;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)directory.getProject());
        return Comparing.equal((Object)fileIndex.getClassRootForFile(vFile), (Object)vFile) || Comparing.equal((Object)fileIndex.getContentRootForFile(vFile), (Object)vFile) || Comparing.equal((Object)fileIndex.getSourceRootForFile(vFile), (Object)vFile);
    }

    public static boolean isResolved(PsiReference reference) {
        if (reference instanceof PsiPolyVariantReference) {
            return ((PsiPolyVariantReference)reference).multiResolve(false).length > 0;
        }
        return reference.resolve() != null;
    }

    private static class CellRenderer
    extends SimpleColoredComponent
    implements ListCellRenderer {
        private final Font FONT;
        private final String myName;

        public CellRenderer(String name) {
            this.myName = name;
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            this.FONT = new Font(scheme.getEditorFontName(), 0, scheme.getEditorFontSize());
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.clear();
            ImportCandidateHolder item = (ImportCandidateHolder)value;
            this.setIcon(item.getImportable().getIcon(0));
            String item_name = item.getPresentableText(this.myName);
            this.append(item_name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.setFont(this.FONT);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

