/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImportCandidateHolder
implements Comparable<ImportCandidateHolder> {
    private final PsiElement myImportable;
    private final PyImportElement myImportElement;
    private final PsiFileSystemItem myFile;
    private final QualifiedName myPath;

    public ImportCandidateHolder(@NotNull PsiElement importable, @NotNull PsiFileSystemItem file, @Nullable PyImportElement importElement, @Nullable QualifiedName path) {
        if (importable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importable", "com/jetbrains/python/codeInsight/imports/ImportCandidateHolder", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/imports/ImportCandidateHolder", "<init>"));
        }
        this.myFile = file;
        this.myImportable = importable;
        this.myImportElement = importElement;
        this.myPath = path;
        assert (importElement != null || path != null);
    }

    @NotNull
    public PsiElement getImportable() {
        PsiElement psiElement = this.myImportable;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/ImportCandidateHolder", "getImportable"));
        }
        return psiElement;
    }

    @Nullable
    public PyImportElement getImportElement() {
        return this.myImportElement;
    }

    @NotNull
    public PsiFileSystemItem getFile() {
        PsiFileSystemItem psiFileSystemItem = this.myFile;
        if (psiFileSystemItem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/ImportCandidateHolder", "getFile"));
        }
        return psiFileSystemItem;
    }

    @Nullable
    public QualifiedName getPath() {
        return this.myPath;
    }

    @NotNull
    public static String getQualifiedName(@NotNull String name, @Nullable QualifiedName importPath, @Nullable PyImportElement source) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/imports/ImportCandidateHolder", "getQualifiedName"));
        }
        StringBuilder sb = new StringBuilder();
        if (source != null) {
            PsiElement parent = source.getParent();
            if (parent instanceof PyFromImportStatement) {
                sb.append(name);
            } else {
                sb.append(source.getVisibleName()).append(".").append(name);
            }
        } else {
            if (importPath != null && importPath.getComponentCount() > 0) {
                sb.append(importPath).append(".");
            }
            sb.append(name);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/ImportCandidateHolder", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    public String getPresentableText(@NotNull String myName) {
        List supers;
        if (myName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myName", "com/jetbrains/python/codeInsight/imports/ImportCandidateHolder", "getPresentableText"));
        }
        StringBuilder sb = new StringBuilder(ImportCandidateHolder.getQualifiedName(myName, this.myPath, this.myImportElement));
        PsiElement parent = null;
        if (this.myImportElement != null) {
            parent = this.myImportElement.getParent();
        }
        if (this.myImportable instanceof PyFunction) {
            sb.append(((PyFunction)this.myImportable).getParameterList().getPresentableText(false));
        } else if (this.myImportable instanceof PyClass && !(supers = ContainerUtil.mapNotNull((Object[])((PyClass)this.myImportable).getSuperClasses(), (Function)new Function<PyClass, String>(){

            public String fun(PyClass cls) {
                return PyUtil.isObjectClass(cls) ? null : cls.getName();
            }
        })).isEmpty()) {
            sb.append("(");
            StringUtil.join((Collection)supers, (String)", ", (StringBuilder)sb);
            sb.append(")");
        }
        if (parent instanceof PyFromImportStatement) {
            sb.append(" from ");
            PyFromImportStatement fromImportStatement = (PyFromImportStatement)parent;
            sb.append(StringUtil.repeat((String)".", (int)fromImportStatement.getRelativeLevel()));
            PyReferenceExpression source = fromImportStatement.getImportSource();
            if (source != null) {
                sb.append(source.getReferencedName());
            }
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/ImportCandidateHolder", "getPresentableText"));
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull ImportCandidateHolder rhs) {
        if (rhs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rhs", "com/jetbrains/python/codeInsight/imports/ImportCandidateHolder", "compareTo"));
        }
        int lRelevance = this.getRelevance();
        int rRelevance = rhs.getRelevance();
        if (rRelevance != lRelevance) {
            return rRelevance - lRelevance;
        }
        if (this.myPath != null && rhs.myPath != null) {
            return this.myPath.getComponentCount() - rhs.myPath.getComponentCount();
        }
        return 0;
    }

    int getRelevance() {
        VirtualFile vFile;
        Project project = this.myImportable.getProject();
        PsiFile psiFile = this.myImportable.getContainingFile();
        VirtualFile virtualFile = vFile = psiFile == null ? null : psiFile.getVirtualFile();
        if (vFile == null) {
            return 0;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = fileIndex.getModuleForFile(vFile);
        if (module != null) {
            return 3;
        }
        if (vFile.getParent().getName().equals("Lib")) {
            return 2;
        }
        if (vFile.getParent().getName().equals("test")) {
            return 0;
        }
        return 1;
    }
}

