/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.imports.ImportCandidateHolder;
import com.jetbrains.python.codeInsight.imports.ImportFromExistingAction;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoImportQuickFix
implements LocalQuickFix,
HighPriorityAction {
    private final PyElement myNode;
    private final PsiReference myReference;
    private final List<ImportCandidateHolder> myImports;
    private final String myInitialName;
    boolean myUseQualifiedImport;
    private boolean myExpended;

    public AutoImportQuickFix(PyElement node, PsiReference reference, boolean qualify) {
        this.myNode = node;
        this.myReference = reference;
        this.myImports = new ArrayList<ImportCandidateHolder>();
        this.myInitialName = this.getNameToImport();
        this.myUseQualifiedImport = qualify;
        this.myExpended = false;
    }

    public void addImport(@NotNull PsiElement importable, @NotNull PsiFile file, @Nullable PyImportElement importElement) {
        if (importable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importable", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix", "addImport"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix", "addImport"));
        }
        this.myImports.add(new ImportCandidateHolder(importable, (PsiFileSystemItem)file, importElement, null));
    }

    public void addImport(@NotNull PsiElement importable, @NotNull PsiFileSystemItem file, @Nullable QualifiedName path) {
        if (importable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importable", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix", "addImport"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix", "addImport"));
        }
        this.myImports.add(new ImportCandidateHolder(importable, file, null, path));
    }

    @NotNull
    public String getText() {
        if (this.myUseQualifiedImport) {
            String string = PyBundle.message("ACT.qualify.with.module", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix", "getText"));
            }
            return string;
        }
        if (this.myImports.size() == 1) {
            String string = "Import '" + this.myImports.get(0).getPresentableText(this.getNameToImport()) + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix", "getText"));
            }
            return string;
        }
        String string = PyBundle.message("ACT.NAME.use.import", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("ACT.FAMILY.import", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix", "getFamilyName"));
        }
        return string;
    }

    public boolean showHint(Editor editor) {
        if (!PyCodeInsightSettings.getInstance().SHOW_IMPORT_POPUP) {
            return false;
        }
        if (this.myNode == null || !this.myNode.isValid() || this.myNode.getName() == null || this.myImports.size() <= 0) {
            return false;
        }
        if (ImportFromExistingAction.isResolved(this.myReference)) {
            return false;
        }
        if (HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
            return false;
        }
        if (this.myNode instanceof PyQualifiedExpression && ((PyQualifiedExpression)this.myNode).isQualified()) {
            return false;
        }
        String name = this.getNameToImport();
        if (!name.equals(this.myInitialName)) {
            return false;
        }
        String message = ShowAutoImportPass.getMessage(this.myImports.size() > 1, ImportCandidateHolder.getQualifiedName(name, this.myImports.get(0).getPath(), this.myImports.get(0).getImportElement()));
        ImportFromExistingAction action = new ImportFromExistingAction(this.myNode, this.myImports, name, this.myUseQualifiedImport, false);
        action.onDone(new Runnable(){

            @Override
            public void run() {
                AutoImportQuickFix.this.myExpended = true;
            }
        });
        HintManager.getInstance().showQuestionHint(editor, message, this.myNode.getTextOffset(), this.myNode.getTextRange().getEndOffset(), (QuestionAction)action);
        return true;
    }

    public boolean isAvailable() {
        return !this.myExpended && this.myNode != null && this.myNode.isValid() && this.myImports.size() > 0;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix", "applyFix"));
        }
        this.invoke(descriptor.getPsiElement().getContainingFile());
        this.myExpended = true;
    }

    public void invoke(PsiFile file) throws IncorrectOperationException {
        if (!this.myReference.getElement().isValid()) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        if (ImportFromExistingAction.isResolved(this.myReference)) {
            return;
        }
        ImportFromExistingAction action = this.createAction();
        action.execute();
        this.myExpended = true;
    }

    @NotNull
    protected ImportFromExistingAction createAction() {
        ImportFromExistingAction importFromExistingAction = new ImportFromExistingAction(this.myNode, this.myImports, this.getNameToImport(), this.myUseQualifiedImport, false);
        if (importFromExistingAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix", "createAction"));
        }
        return importFromExistingAction;
    }

    public void sortCandidates() {
        Collections.sort(this.myImports);
    }

    public int getCandidatesCount() {
        return this.myImports.size();
    }

    public boolean hasOnlyFunctions() {
        for (ImportCandidateHolder holder : this.myImports) {
            if (holder.getImportable() instanceof PyFunction) continue;
            return false;
        }
        return true;
    }

    public String getNameToImport() {
        String text = this.myReference.getElement().getText();
        return this.myReference.getRangeInElement().substring(text);
    }

    public boolean hasProjectImports() {
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myNode.getProject());
        for (ImportCandidateHolder anImport : this.myImports) {
            VirtualFile file = anImport.getFile().getVirtualFile();
            if (file == null || !fileIndex.isInContent(file)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public AutoImportQuickFix forLocalImport() {
        AutoImportQuickFix autoImportQuickFix = new AutoImportQuickFix(this.myNode, this.myReference, this.myUseQualifiedImport){

            @Override
            @NotNull
            public String getName() {
                String string = super.getName() + " locally";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix$2", "getName"));
                }
                return string;
            }

            @Override
            @NotNull
            public String getFamilyName() {
                if ("import locally" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix$2", "getFamilyName"));
                }
                return "import locally";
            }

            @Override
            @NotNull
            protected ImportFromExistingAction createAction() {
                ImportFromExistingAction importFromExistingAction = new ImportFromExistingAction(AutoImportQuickFix.this.myNode, AutoImportQuickFix.this.myImports, this.getNameToImport(), this.myUseQualifiedImport, true);
                if (importFromExistingAction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix$2", "createAction"));
                }
                return importFromExistingAction;
            }
        };
        if (autoImportQuickFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/imports/AutoImportQuickFix", "forLocalImport"));
        }
        return autoImportQuickFix;
    }
}

