/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.documentation.DocStringUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddImportHelper {
    private static final Logger LOG = Logger.getInstance((String)("#" + AddImportHelper.class.getName()));

    private AddImportHelper() {
    }

    public static void addLocalImportStatement(@NotNull PyElement element, @NotNull String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/imports/AddImportHelper", "addLocalImportStatement"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/imports/AddImportHelper", "addLocalImportStatement"));
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(element.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)element);
        PsiElement anchor = AddImportHelper.getLocalInsertPosition(element);
        PsiElement parentElement = PyUtil.sure(anchor).getParent();
        if (parentElement != null) {
            parentElement.addBefore((PsiElement)generator.createImportStatement(languageLevel, name, null), anchor);
        }
    }

    public static void addLocalFromImportStatement(@NotNull PyElement element, @NotNull String qualifier, @NotNull String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/imports/AddImportHelper", "addLocalFromImportStatement"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/jetbrains/python/codeInsight/imports/AddImportHelper", "addLocalFromImportStatement"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/imports/AddImportHelper", "addLocalFromImportStatement"));
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(element.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)element);
        PsiElement anchor = AddImportHelper.getLocalInsertPosition(element);
        PsiElement parentElement = PyUtil.sure(anchor).getParent();
        if (parentElement != null) {
            parentElement.addBefore((PsiElement)generator.createFromImportStatement(languageLevel, qualifier, name, null), anchor);
        }
    }

    @Nullable
    public static PsiElement getLocalInsertPosition(@NotNull PyElement anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/codeInsight/imports/AddImportHelper", "getLocalInsertPosition"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)anchor, PyStatement.class, (boolean)false);
    }

    @Nullable
    public static PsiElement getFileInsertPosition(PsiFile file) {
        return AddImportHelper.getInsertPosition((PsiElement)file, null, null);
    }

    @Nullable
    private static PsiElement getInsertPosition(PsiElement insertParent, @Nullable String nameToImport, @Nullable ImportPriority priority) {
        PsiElement feeler = insertParent.getFirstChild();
        if (feeler == null) {
            return null;
        }
        boolean skippedOverImports = false;
        boolean skippedOverDoc = false;
        PsiElement seeker = feeler;
        boolean isInjected = InjectedLanguageManager.getInstance((Project)feeler.getProject()).isInjectedFragment(feeler.getContainingFile());
        do {
            PyStringLiteralExpression doc_elt;
            if (feeler instanceof PyImportStatementBase && !isInjected) {
                if (nameToImport != null && priority != null && AddImportHelper.shouldInsertBefore(insertParent, (PyImportStatementBase)feeler, nameToImport, priority)) break;
                seeker = feeler;
                feeler = feeler.getNextSibling();
                skippedOverImports = true;
                continue;
            }
            if (PyUtil.instanceOf(feeler, PsiWhiteSpace.class, PsiComment.class)) {
                seeker = feeler;
                feeler = feeler.getNextSibling();
                continue;
            }
            if (skippedOverImports || skippedOverDoc || !(insertParent instanceof PyFile) || (doc_elt = DocStringUtil.findDocStringExpression((PyElement)insertParent)) == null || doc_elt.getParent() != feeler) break;
            seeker = feeler = feeler.getNextSibling();
            skippedOverDoc = true;
        } while (feeler != null);
        return seeker;
    }

    private static boolean shouldInsertBefore(PsiElement element, PyImportStatementBase relativeTo, String nameToImport, ImportPriority priority) {
        PsiElement source;
        QualifiedName relativeToName;
        if (relativeTo instanceof PyFromImportStatement) {
            PyFromImportStatement fromImportStatement = (PyFromImportStatement)relativeTo;
            if (fromImportStatement.isFromFuture()) {
                return false;
            }
            relativeToName = fromImportStatement.getImportSourceQName();
            source = fromImportStatement.resolveImportSource();
        } else {
            PyImportElement[] importElements = relativeTo.getImportElements();
            if (importElements.length == 0) {
                return false;
            }
            relativeToName = importElements[0].getImportedQName();
            source = importElements[0].resolve();
        }
        if (relativeToName == null) {
            return false;
        }
        Object containingFile = source instanceof PsiDirectory ? (PsiDirectory)source : (source != null ? source.getContainingFile() : null);
        ImportPriority relativeToPriority = source == null || containingFile == null ? ImportPriority.BUILTIN : AddImportHelper.getImportPriority(element, (PsiFileSystemItem)containingFile);
        int rc = priority.compareTo(relativeToPriority);
        if (rc < 0) {
            return true;
        }
        if (rc == 0) {
            return nameToImport.compareTo(relativeToName.toString()) < 0;
        }
        return false;
    }

    public static boolean addImportStatement(@NotNull PsiFile file, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/imports/AddImportHelper", "addImportStatement"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/imports/AddImportHelper", "addImportStatement"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        List<PyImportElement> existingImports = ((PyFile)file).getImportTargets();
        for (PyImportElement element : existingImports) {
            QualifiedName qName = element.getImportedQName();
            if (qName == null || !name.equals(qName.toString()) || (asName == null || !asName.equals(element.getAsName())) && asName != null) continue;
            return false;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(file.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
        PyImportStatement importNodeToInsert = generator.createImportStatement(languageLevel, name, asName);
        PyImportStatementBase importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyImportStatementBase.class, (boolean)false);
        PsiFile insertParent = importStatement != null && importStatement.getContainingFile() == file ? importStatement.getParent() : file;
        try {
            if (anchor instanceof PyImportStatementBase) {
                insertParent.addAfter((PsiElement)importNodeToInsert, anchor);
            } else {
                insertParent.addBefore((PsiElement)importNodeToInsert, AddImportHelper.getInsertPosition((PsiElement)insertParent, name, priority));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    public static void addFromImportStatement(@NotNull PsiFile file, @NotNull String from, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/imports/AddImportHelper", "addFromImportStatement"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/codeInsight/imports/AddImportHelper", "addFromImportStatement"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/imports/AddImportHelper", "addFromImportStatement"));
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(file.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
        PyFromImportStatement nodeToInsert = generator.createFromImportStatement(languageLevel, from, name, asName);
        try {
            PyImportStatementBase importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyImportStatementBase.class, (boolean)false);
            Object insertParent = importStatement != null && importStatement.getContainingFile() == file ? importStatement.getParent() : file;
            if (InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file)) {
                PsiElement element = insertParent.addBefore((PsiElement)nodeToInsert, AddImportHelper.getInsertPosition((PsiElement)insertParent, from, priority));
                PsiElement whitespace = element.getNextSibling();
                if (!(whitespace instanceof PsiWhiteSpace)) {
                    whitespace = PsiParserFacade.SERVICE.getInstance((Project)file.getProject()).createWhiteSpaceFromText("  >>> ");
                }
                insertParent.addBefore(whitespace, element);
            } else if (anchor instanceof PyImportStatementBase) {
                insertParent.addAfter((PsiElement)nodeToInsert, anchor);
            } else {
                insertParent.addBefore((PsiElement)nodeToInsert, AddImportHelper.getInsertPosition((PsiElement)insertParent, from, priority));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static boolean addOrUpdateFromImportStatement(@NotNull PsiFile file, @NotNull String from, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/imports/AddImportHelper", "addOrUpdateFromImportStatement"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/python/codeInsight/imports/AddImportHelper", "addOrUpdateFromImportStatement"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/imports/AddImportHelper", "addOrUpdateFromImportStatement"));
        }
        List<PyFromImportStatement> existingImports = ((PyFile)file).getFromImports();
        for (PyFromImportStatement existingImport : existingImports) {
            QualifiedName qName;
            if (existingImport.isStarImport() || (qName = existingImport.getImportSourceQName()) == null || !qName.toString().equals(from) || existingImport.getRelativeLevel() != 0) continue;
            for (PyImportElement el : existingImport.getImportElements()) {
                QualifiedName importedQName = el.getImportedQName();
                if (importedQName == null || !StringUtil.equals((CharSequence)name, (CharSequence)importedQName.toString()) || !StringUtil.equals((CharSequence)asName, (CharSequence)el.getAsName())) continue;
                return false;
            }
            PyElementGenerator generator = PyElementGenerator.getInstance(file.getProject());
            PyImportElement importElement = generator.createImportElement(LanguageLevel.forElement((PsiElement)file), name);
            existingImport.add(importElement);
            return false;
        }
        AddImportHelper.addFromImportStatement(file, from, name, asName, priority, anchor);
        return true;
    }

    public static void addImport(PsiNamedElement target, PsiFile file, PyElement element) {
        boolean useQualified = !PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT;
        PsiFile toImport = target instanceof PsiFileSystemItem ? ((PsiFileSystemItem)target).getParent() : target.getContainingFile();
        ImportPriority priority = AddImportHelper.getImportPriority((PsiElement)file, (PsiFileSystemItem)toImport);
        QualifiedName qName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)target, (PsiElement)element);
        if (qName == null) {
            return;
        }
        String path = qName.toString();
        if (target instanceof PsiFileSystemItem && qName.getComponentCount() == 1) {
            AddImportHelper.addImportStatement(file, path, null, priority, (PsiElement)element);
        } else {
            QualifiedName toImportQName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)toImport, (PsiElement)element);
            if (useQualified) {
                AddImportHelper.addImportStatement(file, path, null, priority, (PsiElement)element);
                PyElementGenerator elementGenerator = PyElementGenerator.getInstance(file.getProject());
                String targetName = PyUtil.getElementNameWithoutExtension(target);
                element.replace((PsiElement)elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)target), toImportQName + "." + targetName));
            } else {
                AddImportHelper.addOrUpdateFromImportStatement(file, toImportQName.toString(), target.getName(), null, priority, (PsiElement)element);
            }
        }
    }

    public static ImportPriority getImportPriority(PsiElement importLocation, @NotNull PsiFileSystemItem toImport) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/jetbrains/python/codeInsight/imports/AddImportHelper", "getImportPriority"));
        }
        VirtualFile vFile = toImport.getVirtualFile();
        if (vFile == null) {
            return ImportPriority.PROJECT;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)toImport.getProject());
        if (projectRootManager.getFileIndex().isInContent(vFile)) {
            return ImportPriority.PROJECT;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)importLocation);
        Sdk pythonSdk = module != null ? PythonSdkType.findPythonSdk(module) : projectRootManager.getProjectSdk();
        return PythonSdkType.isStdLib(vFile, pythonSdk) ? ImportPriority.BUILTIN : ImportPriority.THIRD_PARTY;
    }

    public static enum ImportPriority {
        BUILTIN,
        THIRD_PARTY,
        PROJECT;

    }
}

