/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.psi.PyBreakStatement;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PyHighlightExitPointsHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    private final PsiElement myTarget;

    public PyHighlightExitPointsHandler(Editor editor, PsiFile file, PsiElement target) {
        super(editor, file);
        this.myTarget = target;
    }

    @Override
    public List<PsiElement> getTargets() {
        return Collections.singletonList(this.myTarget);
    }

    @Override
    protected void selectTargets(List<PsiElement> targets, Consumer<List<PsiElement>> selectionConsumer) {
        selectionConsumer.consume(targets);
    }

    @Override
    public void computeUsages(List<PsiElement> targets) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.highlight.return");
        PsiElement parent = this.myTarget.getParent();
        if (!(parent instanceof PyReturnStatement)) {
            return;
        }
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)this.myTarget, PyFunction.class);
        if (function == null) {
            return;
        }
        this.highlightExitPoints((PyReturnStatement)parent, function);
    }

    @Nullable
    private static PsiElement getExitTarget(PsiElement exitStatement) {
        if (exitStatement instanceof PyReturnStatement) {
            return PsiTreeUtil.getParentOfType((PsiElement)exitStatement, PyFunction.class);
        }
        if (exitStatement instanceof PyBreakStatement) {
            return ((PyBreakStatement)exitStatement).getLoopStatement();
        }
        if (exitStatement instanceof PyContinueStatement) {
            return ((PyContinueStatement)exitStatement).getLoopStatement();
        }
        if (exitStatement instanceof PyRaiseStatement) {
            return null;
        }
        return null;
    }

    private void highlightExitPoints(PyReturnStatement statement, PyFunction function) {
        ControlFlow flow = ControlFlowCache.getControlFlow(function);
        Collection<PsiElement> exitStatements = PyHighlightExitPointsHandler.findExitPointsAndStatements(flow);
        if (!exitStatements.contains(statement)) {
            return;
        }
        PsiElement originalTarget = PyHighlightExitPointsHandler.getExitTarget((PsiElement)statement);
        for (PsiElement exitStatement : exitStatements) {
            if (PyHighlightExitPointsHandler.getExitTarget(exitStatement) != originalTarget) continue;
            this.addOccurrence(exitStatement);
        }
        this.myStatusText = CodeInsightBundle.message((String)"status.bar.exit.points.highlighted.message", (Object[])new Object[]{exitStatements.size(), HighlightUsagesHandler.getShortcutText()});
    }

    private static Collection<PsiElement> findExitPointsAndStatements(ControlFlow flow) {
        ArrayList<PsiElement> statements = new ArrayList<PsiElement>();
        Instruction[] instructions = flow.getInstructions();
        for (Instruction instruction : instructions[instructions.length - 1].allPred()) {
            PsiElement statement;
            PsiElement element = instruction.getElement();
            if (element == null || (statement = PyPsiUtils.getStatement(element)) == null) continue;
            statements.add(statement);
        }
        return statements;
    }
}

