/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import org.jetbrains.annotations.NotNull;

public class PyWithFixer
extends PyFixer<PyWithStatement> {
    public PyWithFixer() {
        super(PyWithStatement.class);
    }

    @Override
    public void doApply(@NotNull Editor editor, @NotNull PySmartEnterProcessor processor, @NotNull PyWithStatement withStatement) throws IncorrectOperationException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyWithFixer", "doApply"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyWithFixer", "doApply"));
        }
        if (withStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "withStatement", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyWithFixer", "doApply"));
        }
        PsiElement colonToken = PyUtil.getFirstChildOfType(withStatement, PyTokenTypes.COLON);
        PsiElement withToken = PyUtil.getFirstChildOfType(withStatement, PyTokenTypes.WITH_KEYWORD);
        Document document = editor.getDocument();
        if (colonToken == null && withToken != null) {
            int insertAt = withToken.getTextRange().getEndOffset();
            String textToInsert = ":";
            PyWithItem lastItem = (PyWithItem)ArrayUtil.getLastElement((Object[])withStatement.getWithItems());
            if (lastItem == null || lastItem.getExpression() == null) {
                textToInsert = " :";
                processor.registerUnresolvedError(insertAt + 1);
            } else {
                PyExpression expression = lastItem.getExpression();
                insertAt = expression.getTextRange().getEndOffset();
                PsiElement asToken = PyUtil.getFirstChildOfType((PsiElement)lastItem, PyTokenTypes.AS_KEYWORD);
                if (asToken != null) {
                    insertAt = asToken.getTextRange().getEndOffset();
                    PyExpression target = lastItem.getTarget();
                    if (target != null) {
                        insertAt = target.getTextRange().getEndOffset();
                    } else {
                        textToInsert = " :";
                        processor.registerUnresolvedError(insertAt + 1);
                    }
                }
            }
            document.insertString(insertAt, (CharSequence)textToInsert);
        }
    }
}

