/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.NotNull;

public class PyStringLiteralFixer
extends PyFixer<PyStringLiteralExpression> {
    public PyStringLiteralFixer() {
        super(PyStringLiteralExpression.class);
    }

    @Override
    public void doApply(@NotNull Editor editor, @NotNull PySmartEnterProcessor processor, @NotNull PyStringLiteralExpression psiElement) throws IncorrectOperationException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyStringLiteralFixer", "doApply"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyStringLiteralFixer", "doApply"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyStringLiteralFixer", "doApply"));
        }
        String text = psiElement.getText();
        if (StringUtil.startsWith((CharSequence)text, (CharSequence)"\"\"\"")) {
            int suffixLength = StringUtil.commonSuffixLength((CharSequence)text, (CharSequence)"\"\"\"");
            if (suffixLength != 3) {
                editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"\"\"\"".substring(suffixLength));
            }
        } else if (StringUtil.startsWith((CharSequence)text, (CharSequence)"'''")) {
            int suffixLength = StringUtil.commonSuffixLength((CharSequence)text, (CharSequence)"'''");
            if (suffixLength != 3) {
                editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"'''".substring(suffixLength));
            }
        } else if (StringUtil.startsWith((CharSequence)text, (CharSequence)"\"")) {
            if (!StringUtil.endsWith((CharSequence)text, (CharSequence)"\"")) {
                editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"\"");
            }
        } else if (StringUtil.startsWith((CharSequence)text, (CharSequence)"'") && !StringUtil.endsWith((CharSequence)text, (CharSequence)"'")) {
            editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"'");
        }
    }
}

