/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;

public class PyParameterListFixer
extends PyFixer<PyParameterList> {
    public PyParameterListFixer() {
        super(PyParameterList.class);
    }

    @Override
    public void doApply(@NotNull Editor editor, @NotNull PySmartEnterProcessor processor, @NotNull PyParameterList psiElement) throws IncorrectOperationException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyParameterListFixer", "doApply"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyParameterListFixer", "doApply"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyParameterListFixer", "doApply"));
        }
        PsiElement lBrace = PyUtil.getChildByFilter((PsiElement)psiElement, PyTokenTypes.OPEN_BRACES, 0);
        PsiElement rBrace = PyUtil.getChildByFilter((PsiElement)psiElement, PyTokenTypes.CLOSE_BRACES, 0);
        if (lBrace == null || rBrace == null) {
            Document document = editor.getDocument();
            if (lBrace == null) {
                document.insertString(psiElement.getTextRange().getStartOffset(), (CharSequence)"(");
            } else {
                document.insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)")");
            }
        }
    }
}

