/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;

public class PyMissingBracesFixer
extends PyFixer<PyElement> {
    public PyMissingBracesFixer() {
        super(PyElement.class);
    }

    @Override
    public void doApply(@NotNull Editor editor, @NotNull PySmartEnterProcessor processor, @NotNull PyElement psiElement) throws IncorrectOperationException {
        PsiElement lastChild;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyMissingBracesFixer", "doApply"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyMissingBracesFixer", "doApply"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyMissingBracesFixer", "doApply"));
        }
        if (psiElement instanceof PySetLiteralExpression || psiElement instanceof PyDictLiteralExpression) {
            PsiElement lastChild2 = PyUtil.getFirstNonCommentBefore(psiElement.getLastChild());
            if (lastChild2 != null && !"}".equals(lastChild2.getText())) {
                editor.getDocument().insertString(lastChild2.getTextRange().getEndOffset(), (CharSequence)"}");
            }
        } else if ((psiElement instanceof PyListLiteralExpression || psiElement instanceof PySliceExpression || psiElement instanceof PySubscriptionExpression) && (lastChild = PyUtil.getFirstNonCommentBefore(psiElement.getLastChild())) != null && !"]".equals(lastChild.getText())) {
            editor.getDocument().insertString(lastChild.getTextRange().getEndOffset(), (CharSequence)"]");
        }
    }
}

