/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;

public class PyForPartFixer
extends PyFixer<PyForPart> {
    public PyForPartFixer() {
        super(PyForPart.class);
    }

    @Override
    public void doApply(@NotNull Editor editor, @NotNull PySmartEnterProcessor processor, @NotNull PyForPart forPart) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyForPartFixer", "doApply"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyForPartFixer", "doApply"));
        }
        if (forPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forPart", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyForPartFixer", "doApply"));
        }
        PsiElement colon = PyUtil.getFirstChildOfType((PsiElement)forPart, PyTokenTypes.COLON);
        Document document = editor.getDocument();
        PsiElement forToken = PyUtil.getFirstChildOfType((PsiElement)forPart, PyTokenTypes.FOR_KEYWORD);
        if (colon == null) {
            PyExpression sourceOrTarget;
            String textToInsert = ":";
            PyExpression positionToInsert = sourceOrTarget = forPart.getSource();
            if (sourceOrTarget == null) {
                sourceOrTarget = forPart.getTarget();
                PsiElement inToken = PyUtil.getFirstChildOfType((PsiElement)forPart, PyTokenTypes.IN_KEYWORD);
                if (inToken == null) {
                    if (sourceOrTarget == null) {
                        positionToInsert = PyUtil.sure(forToken);
                        textToInsert = "  in :";
                        processor.registerUnresolvedError(positionToInsert.getTextRange().getEndOffset() + 1);
                    } else {
                        positionToInsert = sourceOrTarget;
                        textToInsert = " in :";
                        processor.registerUnresolvedError(positionToInsert.getTextRange().getEndOffset() + 4);
                    }
                } else {
                    positionToInsert = inToken;
                    textToInsert = " :";
                    processor.registerUnresolvedError(positionToInsert.getTextRange().getEndOffset() + 1);
                }
            }
            document.insertString(positionToInsert.getTextRange().getEndOffset(), (CharSequence)textToInsert);
        }
    }
}

