/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;

public class PyExceptFixer
extends PyFixer<PyExceptPart> {
    public PyExceptFixer() {
        super(PyExceptPart.class);
    }

    @Override
    public void doApply(@NotNull Editor editor, @NotNull PySmartEnterProcessor processor, @NotNull PyExceptPart exceptPart) throws IncorrectOperationException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyExceptFixer", "doApply"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyExceptFixer", "doApply"));
        }
        if (exceptPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptPart", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyExceptFixer", "doApply"));
        }
        PsiElement colon = PyUtil.getFirstChildOfType(exceptPart, PyTokenTypes.COLON);
        if (colon == null) {
            PyExpression target;
            PsiElement exceptToken = PyUtil.getFirstChildOfType(exceptPart, PyTokenTypes.EXCEPT_KEYWORD);
            int offset = PyUtil.sure(exceptToken).getTextRange().getEndOffset();
            PyExpression exceptClass = exceptPart.getExceptClass();
            if (exceptClass != null) {
                offset = exceptClass.getTextRange().getEndOffset();
            }
            if ((target = exceptPart.getTarget()) != null) {
                offset = target.getTextRange().getEndOffset();
            }
            editor.getDocument().insertString(offset, (CharSequence)":");
        }
    }
}

