/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.psi.PyConditionalStatementPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;

public class PyConditionalStatementPartFixer
extends PyFixer<PyConditionalStatementPart> {
    public PyConditionalStatementPartFixer() {
        super(PyConditionalStatementPart.class);
    }

    @Override
    public void doApply(@NotNull Editor editor, @NotNull PySmartEnterProcessor processor, @NotNull PyConditionalStatementPart statementPart) throws IncorrectOperationException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyConditionalStatementPartFixer", "doApply"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyConditionalStatementPartFixer", "doApply"));
        }
        if (statementPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementPart", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyConditionalStatementPartFixer", "doApply"));
        }
        PyExpression condition = statementPart.getCondition();
        Document document = editor.getDocument();
        PsiElement colon = PyUtil.getFirstChildOfType((PsiElement)statementPart, PyTokenTypes.COLON);
        if (colon == null) {
            if (condition != null) {
                PsiElement firstNonComment = PyUtil.getFirstNonCommentAfter(condition.getNextSibling());
                if (firstNonComment != null && !":".equals(firstNonComment.getNode().getText())) {
                    document.insertString(firstNonComment.getTextRange().getEndOffset(), (CharSequence)":");
                }
            } else {
                TokenSet keywords = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.IF_KEYWORD, PyTokenTypes.ELIF_KEYWORD, PyTokenTypes.WHILE_KEYWORD});
                PsiElement keywordToken = PyUtil.getChildByFilter((PsiElement)statementPart, keywords, 0);
                int offset = PyUtil.sure(keywordToken).getTextRange().getEndOffset();
                document.insertString(offset, (CharSequence)" :");
                processor.registerUnresolvedError(offset + 1);
            }
        } else if (condition == null) {
            processor.registerUnresolvedError(colon.getTextRange().getStartOffset());
        }
    }
}

