/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;

public class PyClassFixer
extends PyFixer<PyClass> {
    public PyClassFixer() {
        super(PyClass.class);
    }

    @Override
    public void doApply(@NotNull Editor editor, @NotNull PySmartEnterProcessor processor, @NotNull PyClass pyClass) throws IncorrectOperationException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyClassFixer", "doApply"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyClassFixer", "doApply"));
        }
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyClassFixer", "doApply"));
        }
        PsiElement colon = PyUtil.getFirstChildOfType(pyClass, PyTokenTypes.COLON);
        if (colon == null) {
            PyArgumentList argList = (PyArgumentList)PsiTreeUtil.getChildOfType((PsiElement)pyClass, PyArgumentList.class);
            int offset = PyUtil.sure(argList).getTextRange().getEndOffset();
            String textToInsert = ":";
            if (pyClass.getNameNode() == null) {
                processor.registerUnresolvedError(argList.getTextRange().getEndOffset() + 1);
                textToInsert = " :";
            }
            editor.getDocument().insertString(offset, (CharSequence)textToInsert);
        }
    }
}

