/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;

public class PyArgumentListFixer
extends PyFixer<PyArgumentList> {
    public PyArgumentListFixer() {
        super(PyArgumentList.class);
    }

    @Override
    public void doApply(@NotNull Editor editor, @NotNull PySmartEnterProcessor processor, @NotNull PyArgumentList arguments) throws IncorrectOperationException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyArgumentListFixer", "doApply"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyArgumentListFixer", "doApply"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyArgumentListFixer", "doApply"));
        }
        PsiElement rBrace = PyUtil.getChildByFilter((PsiElement)arguments, PyTokenTypes.CLOSE_BRACES, 0);
        if (arguments.getParent() instanceof PyClass || arguments.getParent() instanceof PyDecorator) {
            PsiElement lBrace = PyUtil.getChildByFilter((PsiElement)arguments, PyTokenTypes.OPEN_BRACES, 0);
            if (lBrace != null && rBrace == null) {
                Document document = editor.getDocument();
                document.insertString(arguments.getTextRange().getEndOffset(), (CharSequence)")");
            }
        } else if (rBrace == null) {
            Document document = editor.getDocument();
            document.insertString(arguments.getTextRange().getEndOffset(), (CharSequence)")");
        }
    }
}

