/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.SmartEnterUtil;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.enterProcessors.EnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.enterProcessors.PyCommentBreakerEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.enterProcessors.PyPlainEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyArgumentListFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyClassFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyConditionalStatementPartFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyExceptFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyForPartFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFunctionFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyMissingBracesFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyParameterListFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyParenthesizedFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyStringLiteralFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyUnconditionalStatementPartFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyWithFixer;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySmartEnterProcessor
extends SmartEnterProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor");
    private static final List<PyFixer> ourFixers = ImmutableList.builder().add((Object)new PyStringLiteralFixer()).add((Object)new PyParenthesizedFixer()).add((Object)new PyMissingBracesFixer()).add((Object)new PyConditionalStatementPartFixer()).add((Object)new PyUnconditionalStatementPartFixer()).add((Object)new PyForPartFixer()).add((Object)new PyExceptFixer()).add((Object)new PyArgumentListFixer()).add((Object)new PyParameterListFixer()).add((Object)new PyFunctionFixer()).add((Object)new PyClassFixer()).add((Object)new PyWithFixer()).build();
    private static final List<EnterProcessor> ourProcessors = ImmutableList.of((Object)new PyCommentBreakerEnterProcessor(), (Object)new PyPlainEnterProcessor());
    private int myFirstErrorOffset = Integer.MAX_VALUE;
    private static final int MAX_ATTEMPTS = 20;
    private static final Key<Long> SMART_ENTER_TIMESTAMP = Key.create((String)"smartEnterOriginalTimestamp");

    private static void collectAllElements(PsiElement element, @NotNull List<PsiElement> result, boolean recurse) {
        PsiElement[] children;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/editorActions/smartEnter/PySmartEnterProcessor", "collectAllElements"));
        }
        result.add(0, element);
        if (PySmartEnterProcessor.doNotStep(element)) {
            if (!recurse) {
                return;
            }
            recurse = false;
        }
        for (PsiElement child : children = element.getChildren()) {
            if (element instanceof PyStatement && child instanceof PyStatement) continue;
            PySmartEnterProcessor.collectAllElements(child, result, recurse);
        }
    }

    private static boolean doNotStep(PsiElement element) {
        return element instanceof PyStatementList || element instanceof PyStatement;
    }

    private static boolean isModified(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/PySmartEnterProcessor", "isModified"));
        }
        Long timestamp = (Long)editor.getUserData(SMART_ENTER_TIMESTAMP);
        return editor.getDocument().getModificationStamp() != timestamp.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/editorActions/smartEnter/PySmartEnterProcessor", "process"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/PySmartEnterProcessor", "process"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/python/codeInsight/editorActions/smartEnter/PySmartEnterProcessor", "process"));
        }
        Document document = editor.getDocument();
        String textForRollBack = document.getText();
        int offset = editor.getCaretModel().getOffset();
        try {
            editor.putUserData(SMART_ENTER_TIMESTAMP, (Object)editor.getDocument().getModificationStamp());
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            this.process(project, editor, psiFile, 0);
        }
        catch (TooManyAttemptsException e) {
            LOG.info((Throwable)e);
            document.replaceString(0, document.getTextLength(), (CharSequence)textForRollBack);
            editor.getCaretModel().moveToOffset(offset);
        }
        finally {
            editor.putUserData(SMART_ENTER_TIMESTAMP, null);
        }
        return true;
    }

    private void process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile, int attempt) throws TooManyAttemptsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/editorActions/smartEnter/PySmartEnterProcessor", "process"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/smartEnter/PySmartEnterProcessor", "process"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/python/codeInsight/editorActions/smartEnter/PySmartEnterProcessor", "process"));
        }
        if (attempt > 20) {
            throw new TooManyAttemptsException();
        }
        try {
            PsiElement statementAtCaret;
            this.commit(editor);
            if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
                editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            }
            if ((statementAtCaret = this.getStatementAtCaret(editor, psiFile)) == null) {
                if (!new PyCommentBreakerEnterProcessor().doEnter(editor, (PsiElement)psiFile, false)) {
                    SmartEnterUtil.plainEnter(editor);
                }
                return;
            }
            ArrayList<PsiElement> queue = new ArrayList<PsiElement>();
            PySmartEnterProcessor.collectAllElements(statementAtCaret, queue, true);
            queue.add(statementAtCaret);
            for (PsiElement element : queue) {
                for (PyFixer fixer : ourFixers) {
                    fixer.apply(editor, this, element);
                    if (LookupManager.getInstance(project).getActiveLookup() != null) {
                        return;
                    }
                    if (!PySmartEnterProcessor.isUncommited((Project)project) && element.isValid()) continue;
                    this.process(project, editor, psiFile, attempt + 1);
                    return;
                }
            }
            this.doEnter(statementAtCaret, editor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void doEnter(PsiElement atCaret, Editor editor) {
        if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            return;
        }
        this.commit(editor);
        for (EnterProcessor enterProcessor : ourProcessors) {
            if (!enterProcessor.doEnter(editor, atCaret, PySmartEnterProcessor.isModified(editor))) continue;
            return;
        }
        if (!PySmartEnterProcessor.isModified(editor)) {
            SmartEnterUtil.plainEnter(editor);
        } else if (this.myFirstErrorOffset == Integer.MAX_VALUE) {
            editor.getCaretModel().moveToOffset(atCaret.getTextRange().getEndOffset());
        } else {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
        }
    }

    @Nullable
    protected PsiElement getStatementAtCaret(Editor editor, PsiFile psiFile) {
        block5: {
            PsiElement statementAtCaret;
            block4: {
                statementAtCaret = super.getStatementAtCaret(editor, psiFile);
                if (statementAtCaret instanceof PsiWhiteSpace) {
                    return null;
                }
                if (statementAtCaret == null) {
                    return null;
                }
                PyStatementList statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)statementAtCaret, PyStatementList.class, (boolean)false);
                if (statementList == null) break block4;
                for (PyStatement statement : statementList.getStatements()) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)statementAtCaret, (boolean)true)) continue;
                    return statement;
                }
                break block5;
            }
            PyFile file = (PyFile)PsiTreeUtil.getParentOfType((PsiElement)statementAtCaret, PyFile.class, (boolean)false);
            if (file == null) break block5;
            for (PyStatement statement : file.getStatements()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)statementAtCaret, (boolean)true)) continue;
                return statement;
            }
        }
        return null;
    }

    public void registerUnresolvedError(int offset) {
        if (offset < this.myFirstErrorOffset) {
            this.myFirstErrorOffset = offset;
        }
    }

    private static class TooManyAttemptsException
    extends Exception {
        private TooManyAttemptsException() {
        }
    }
}

