/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementPart;
import com.jetbrains.python.psi.PyStatementWithElse;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStatementMover
extends LineMover {
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        int end;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "checkAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "checkAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "checkAvailable"));
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        SelectionModel selectionModel = editor.getSelectionModel();
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(offset);
        int start = PyStatementMover.getLineStartSafeOffset((Document)document, (int)lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        int n = end = lineEndOffset == 0 ? 0 : lineEndOffset - 1;
        if (selectionModel.hasSelection()) {
            start = selectionModel.getSelectionStart();
            int selectionEnd = selectionModel.getSelectionEnd();
            end = selectionEnd == 0 ? 0 : selectionEnd - 1;
        }
        PsiElement elementToMove1 = PyUtil.findNonWhitespaceAtOffset(file, start);
        PsiElement elementToMove2 = PyUtil.findNonWhitespaceAtOffset(file, end);
        if (elementToMove1 == null || elementToMove2 == null) {
            return false;
        }
        if (PyStatementMover.ifInsideString(document, lineNumber, elementToMove1, down)) {
            return false;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)(elementToMove1 = PyStatementMover.getCommentOrStatement(document, elementToMove1)), (PsiElement)(elementToMove2 = PyStatementMover.getCommentOrStatement(document, elementToMove2)), (boolean)false)) {
            elementToMove2 = elementToMove1;
        } else if (PsiTreeUtil.isAncestor((PsiElement)elementToMove2, (PsiElement)elementToMove1, (boolean)false)) {
            elementToMove1 = elementToMove2;
        }
        info.toMove = new MyLineRange(elementToMove1, elementToMove2);
        info.toMove2 = PyStatementMover.getDestinationScope(file, editor, down ? elementToMove2 : elementToMove1, down);
        info.indentTarget = false;
        info.indentSource = false;
        return true;
    }

    private static boolean ifInsideString(@NotNull Document document, int lineNumber, @NotNull PsiElement elementToMove1, boolean down) {
        Pair<String, String> quotes;
        int nearLine;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "ifInsideString"));
        }
        if (elementToMove1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToMove1", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "ifInsideString"));
        }
        int start = document.getLineStartOffset(lineNumber);
        int end = document.getLineEndOffset(lineNumber);
        int n = nearLine = down ? lineNumber + 1 : lineNumber - 1;
        if (nearLine >= document.getLineCount() || nearLine <= 0) {
            return false;
        }
        PyStringLiteralExpression stringLiteralExpression = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)elementToMove1, PyStringLiteralExpression.class);
        if (stringLiteralExpression != null && (quotes = PythonStringUtil.getQuotes(stringLiteralExpression.getText())) != null && (((String)quotes.first).equals("'''") || ((String)quotes.first).equals("\"\"\""))) {
            String text1 = document.getText(TextRange.create((int)start, (int)end)).trim();
            String text2 = document.getText(TextRange.create((int)document.getLineStartOffset(nearLine), (int)document.getLineEndOffset(nearLine))).trim();
            if (!(text1.startsWith((String)quotes.first) || text1.endsWith((String)quotes.second) || text2.startsWith((String)quotes.first) || text2.endsWith((String)quotes.second))) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static LineRange getDestinationScope(@NotNull PsiFile file, @NotNull Editor editor, @NotNull PsiElement elementToMove, boolean down) {
        PyStatementList scope;
        String lineText;
        boolean isEmptyLine;
        int lineNumber;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "getDestinationScope"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "getDestinationScope"));
        }
        if (elementToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToMove", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "getDestinationScope"));
        }
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            return null;
        }
        int offset = down ? elementToMove.getTextRange().getEndOffset() : elementToMove.getTextRange().getStartOffset();
        int n = lineNumber = down ? document.getLineNumber(offset) + 1 : document.getLineNumber(offset) - 1;
        if (PyStatementMover.moveOutsideFile(document, lineNumber)) {
            return null;
        }
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        int startOffset = document.getLineStartOffset(lineNumber);
        PyStatementList statementList = PyStatementMover.getStatementList(elementToMove);
        PsiElement destination = PyStatementMover.getDestinationElement(elementToMove, document, lineEndOffset, down);
        int start = destination != null ? destination.getTextRange().getStartOffset() : lineNumber;
        int end = destination != null ? destination.getTextRange().getEndOffset() : lineNumber;
        int startLine = document.getLineNumber(start);
        int endLine = document.getLineNumber(end);
        if (elementToMove instanceof PyClass || elementToMove instanceof PyFunction) {
            PyStatementList scope2;
            PyElement pyElement = scope2 = statementList == null ? (PyElement)elementToMove.getContainingFile() : statementList;
            if (destination != null) {
                return new ScopeRange(scope2, destination, !down, true);
            }
        }
        if ((isEmptyLine = StringUtil.isEmptyOrSpaces((String)(lineText = document.getText(TextRange.create((int)startOffset, (int)lineEndOffset))))) && PyStatementMover.moveToEmptyLine(elementToMove, down)) {
            return new LineRange(lineNumber, lineNumber + 1);
        }
        ScopeRange scopeRange = PyStatementMover.moveOut(elementToMove, editor, down);
        if (scopeRange != null) {
            return scopeRange;
        }
        scopeRange = PyStatementMover.moveInto(elementToMove, file, editor, down, lineEndOffset);
        if (scopeRange != null) {
            return scopeRange;
        }
        if (elementToMove instanceof PsiComment && PsiTreeUtil.isAncestor((PsiElement)destination, (PsiElement)elementToMove, (boolean)true) || destination instanceof PsiComment) {
            return new LineRange(lineNumber, lineNumber + 1);
        }
        PyElement pyElement = scope = statementList == null ? (PyElement)elementToMove.getContainingFile() : statementList;
        if (elementToMove instanceof PyClass || elementToMove instanceof PyFunction) {
            return new ScopeRange(scope, scope.getFirstChild(), !down, true);
        }
        return new LineRange(startLine, endLine + 1);
    }

    private static boolean moveOutsideFile(@NotNull Document document, int lineNumber) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveOutsideFile"));
        }
        return lineNumber < 0 || lineNumber >= document.getLineCount();
    }

    private static boolean moveToEmptyLine(@NotNull PsiElement elementToMove, boolean down) {
        if (elementToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToMove", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveToEmptyLine"));
        }
        PyStatementList statementList = PyStatementMover.getStatementList(elementToMove);
        if (statementList != null) {
            if (down) {
                PsiElement child = statementList.getLastChild();
                if (elementToMove == child && PsiTreeUtil.getNextSiblingOfType((PsiElement)statementList.getParent(), PyStatementPart.class) != null || child != elementToMove) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return statementList == null;
    }

    private static PyStatementList getStatementList(@NotNull PsiElement elementToMove) {
        if (elementToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToMove", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "getStatementList"));
        }
        return (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)elementToMove, PyStatementList.class, (boolean)true, (Class[])new Class[]{PyStatementWithElse.class, PyLoopStatement.class, PyFunction.class, PyClass.class});
    }

    @Nullable
    private static ScopeRange moveOut(@NotNull PsiElement elementToMove, @NotNull Editor editor, boolean down) {
        PyStatementPart sibling;
        if (elementToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToMove", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveOut"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveOut"));
        }
        PyStatementList statementList = PyStatementMover.getStatementList(elementToMove);
        if (statementList == null) {
            return null;
        }
        if (!(down && statementList.getLastChild() == elementToMove || !down && statementList.getFirstChild() == elementToMove)) {
            return null;
        }
        boolean addBefore = !down;
        PsiElement parent = statementList.getParent();
        PyStatementPart pyStatementPart = sibling = down ? (PyStatementPart)PsiTreeUtil.getNextSiblingOfType((PsiElement)parent, PyStatementPart.class) : (PyStatementPart)PsiTreeUtil.getPrevSiblingOfType((PsiElement)parent, PyStatementPart.class);
        if (sibling != null) {
            PyStatementList list = sibling.getStatementList();
            return new ScopeRange((PsiElement)list, down ? list.getFirstChild() : list.getLastChild(), !addBefore);
        }
        PsiElement scope = PyStatementMover.getScopeForComment(elementToMove, editor, parent, !down);
        PsiElement anchor = PsiTreeUtil.getParentOfType((PsiElement)statementList, PyStatement.class);
        return scope == null || anchor == null ? null : new ScopeRange(scope, anchor, addBefore);
    }

    private static PsiElement getScopeForComment(@NotNull PsiElement elementToMove, @NotNull Editor editor, @Nullable PsiElement parent, boolean down) {
        if (elementToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToMove", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "getScopeForComment"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "getScopeForComment"));
        }
        PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PyStatementList.class, PyFile.class});
        int offset = elementToMove.getTextOffset();
        PsiElement sibling = elementToMove;
        while (scope != null && elementToMove instanceof PsiComment) {
            PyStatement prevSibling;
            PyStatement pyStatement = prevSibling = down ? (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)sibling, PyStatement.class) : (PyStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)sibling, PyStatement.class);
            if (prevSibling == null || editor.offsetToLogicalPosition((int)prevSibling.getTextOffset()).column == editor.offsetToLogicalPosition((int)offset).column) break;
            sibling = scope;
            scope = PsiTreeUtil.getParentOfType((PsiElement)scope, (Class[])new Class[]{PyStatementList.class, PyFile.class});
        }
        return scope;
    }

    @Nullable
    private static LineRange moveInto(@NotNull PsiElement elementToMove, @NotNull PsiFile file, @NotNull Editor editor, boolean down, int offset) {
        if (elementToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToMove", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveInto"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveInto"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveInto"));
        }
        PsiElement rawElement = PyUtil.findNonWhitespaceAtOffset(file, offset);
        if (rawElement == null) {
            return null;
        }
        return down ? PyStatementMover.moveDownInto(editor.getDocument(), rawElement) : PyStatementMover.moveUpInto(elementToMove, editor, rawElement, false);
    }

    @Nullable
    private static LineRange moveUpInto(@NotNull PsiElement elementToMove, @NotNull Editor editor, @NotNull PsiElement rawElement, boolean down) {
        int start2;
        if (elementToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToMove", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveUpInto"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveUpInto"));
        }
        if (rawElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawElement", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveUpInto"));
        }
        Document document = editor.getDocument();
        PsiElement element = PyStatementMover.getCommentOrStatement(document, rawElement);
        PyStatementList statementList = PyStatementMover.getStatementList(elementToMove);
        PsiElement scopeForComment = statementList == null ? null : PyStatementMover.getScopeForComment(elementToMove, editor, elementToMove, down);
        PyStatementList statementList2 = PyStatementMover.getStatementList(element);
        int start1 = elementToMove.getTextOffset() - document.getLineStartOffset(document.getLineNumber(elementToMove.getTextOffset()));
        if (start1 != (start2 = element.getTextOffset() - document.getLineStartOffset(document.getLineNumber(element.getTextOffset())))) {
            PyStatementList parent2 = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)statementList2, PyStatementList.class);
            while (parent2 != scopeForComment && parent2 != null) {
                element = PsiTreeUtil.getParentOfType((PsiElement)statementList2, PyStatement.class);
                statementList2 = parent2;
                parent2 = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)parent2, PyStatementList.class);
            }
        }
        if (statementList2 != null && scopeForComment != statementList2 && (statementList2.getLastChild() == element || statementList2.getLastChild() == elementToMove) && element != null) {
            return new ScopeRange((PsiElement)statementList2, element, false);
        }
        return null;
    }

    @Nullable
    private static LineRange moveDownInto(@NotNull Document document, @NotNull PsiElement rawElement) {
        int number2;
        int number;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveDownInto"));
        }
        if (rawElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawElement", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveDownInto"));
        }
        PsiElement element = PyStatementMover.getCommentOrStatement(document, rawElement);
        PyStatementList statementList2 = PyStatementMover.getStatementList(element);
        if (statementList2 != null && (number = document.getLineNumber(element.getTextOffset())) == (number2 = document.getLineNumber(statementList2.getParent().getTextOffset()))) {
            return new ScopeRange((PsiElement)statementList2, statementList2.getFirstChild(), true);
        }
        PyStatementPart statementPart = (PyStatementPart)PsiTreeUtil.getParentOfType((PsiElement)rawElement, PyStatementPart.class, (boolean)true, (Class[])new Class[]{PyStatement.class, PyStatementList.class});
        PyFunction functionDefinition = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)rawElement, PyFunction.class, (boolean)true, (Class[])new Class[]{PyStatement.class, PyStatementList.class});
        PyClass classDefinition = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)rawElement, PyClass.class, (boolean)true, (Class[])new Class[]{PyStatement.class, PyStatementList.class});
        PyStatementList list = null;
        if (statementPart != null) {
            list = statementPart.getStatementList();
        } else if (functionDefinition != null) {
            list = functionDefinition.getStatementList();
        } else if (classDefinition != null) {
            list = classDefinition.getStatementList();
        }
        if (list != null) {
            return new ScopeRange((PsiElement)list, list.getFirstChild(), true);
        }
        return null;
    }

    private static PsiElement getDestinationElement(@NotNull PsiElement elementToMove, @NotNull Document document, int lineEndOffset, boolean down) {
        PyStatement sibling;
        if (elementToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToMove", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "getDestinationElement"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "getDestinationElement"));
        }
        Object destination = PyUtil.findPrevAtOffset(elementToMove.getContainingFile(), lineEndOffset, PsiWhiteSpace.class);
        PyStatement pyStatement = sibling = down ? (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)elementToMove, PyStatement.class) : (PyStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)elementToMove, PyStatement.class);
        if (destination == null) {
            if (elementToMove instanceof PyClass) {
                destination = sibling;
            } else if (elementToMove instanceof PyFunction) {
                destination = !(sibling instanceof PyClass) ? sibling : null;
            } else {
                return null;
            }
        }
        if (destination instanceof PsiComment) {
            return destination;
        }
        destination = elementToMove instanceof PyClass ? sibling : (elementToMove instanceof PyFunction ? (!(sibling instanceof PyClass) ? sibling : null) : PyStatementMover.getCommentOrStatement(document, (PsiElement)(sibling == null ? destination : sibling)));
        return destination;
    }

    @NotNull
    private static PsiElement getCommentOrStatement(@NotNull Document document, @NotNull PsiElement destination) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "getCommentOrStatement"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "getCommentOrStatement"));
        }
        PsiElement statement = PsiTreeUtil.getParentOfType((PsiElement)destination, PyStatement.class, (boolean)false);
        if (statement == null) {
            PsiElement psiElement = destination;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "getCommentOrStatement"));
            }
            return psiElement;
        }
        if (destination instanceof PsiComment) {
            if (document.getLineNumber(destination.getTextOffset()) == document.getLineNumber(statement.getTextOffset())) {
                destination = statement;
            }
        } else {
            destination = statement;
        }
        PsiElement psiElement = destination;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "getCommentOrStatement"));
        }
        return psiElement;
    }

    public void beforeMove(final @NotNull Editor editor, final @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "beforeMove"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "beforeMove"));
        }
        final LineRange toMove = info.toMove;
        final LineRange toMove2 = info.toMove2;
        if (toMove instanceof MyLineRange && toMove2 instanceof ScopeRange) {
            PostprocessReformattingAspect.getInstance(editor.getProject()).disablePostprocessFormattingInside(new Runnable(){

                @Override
                public void run() {
                    PsiElement startToMove = ((MyLineRange)toMove).myStartElement;
                    PsiElement endToMove = ((MyLineRange)toMove).myEndElement;
                    PsiFile file = startToMove.getContainingFile();
                    SelectionModel selectionModel = editor.getSelectionModel();
                    CaretModel caretModel = editor.getCaretModel();
                    int selectionStart = selectionModel.getSelectionStart();
                    boolean isSelectionStartAtCaret = caretModel.getOffset() == selectionStart;
                    SelectionContainer selectionLen = PyStatementMover.getSelectionLenContainer(editor, (MyLineRange)toMove);
                    int shift = PyStatementMover.getCaretShift(startToMove, endToMove, caretModel, isSelectionStartAtCaret);
                    boolean hasSelection = selectionModel.hasSelection();
                    int offset = ((ScopeRange)toMove2).isTheSameLevel() ? PyStatementMover.moveTheSameLevel((ScopeRange)toMove2, (MyLineRange)toMove) : PyStatementMover.moveInOut((MyLineRange)toMove, editor, info);
                    PyStatementMover.restoreCaretAndSelection(file, editor, isSelectionStartAtCaret, hasSelection, selectionLen, shift, offset, (MyLineRange)toMove);
                    info.toMove2 = info.toMove;
                }
            });
        }
    }

    private static SelectionContainer getSelectionLenContainer(@NotNull Editor editor, @NotNull MyLineRange toMove) {
        int additionalSelection;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "getSelectionLenContainer"));
        }
        if (toMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toMove", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "getSelectionLenContainer"));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        PsiElement startToMove = toMove.myStartElement;
        PsiElement endToMove = toMove.myEndElement;
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        TextRange range = startToMove.getTextRange();
        int column = editor.offsetToLogicalPosition((int)selectionStart).column;
        int n = additionalSelection = range.getStartOffset() > selectionStart ? range.getStartOffset() - selectionStart : 0;
        if (startToMove == endToMove) {
            return new SelectionContainer(selectionEnd - range.getStartOffset(), additionalSelection, column == 0);
        }
        int len = range.getStartOffset() <= selectionStart ? range.getEndOffset() - selectionStart : startToMove.getTextLength();
        for (PsiElement tmp = startToMove.getNextSibling(); tmp != endToMove && tmp != null; tmp = tmp.getNextSibling()) {
            if (tmp instanceof PsiWhiteSpace) continue;
            len += tmp.getTextLength();
        }
        len = len + selectionEnd - endToMove.getTextOffset();
        return new SelectionContainer(len, additionalSelection, column == 0);
    }

    private static void restoreCaretAndSelection(@NotNull PsiFile file, @NotNull Editor editor, boolean selectionStartAtCaret, boolean hasSelection, @NotNull SelectionContainer selectionContainer, int shift, int offset, @NotNull MyLineRange toMove) {
        int documentLength;
        int newCaretOffset;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "restoreCaretAndSelection"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "restoreCaretAndSelection"));
        }
        if (selectionContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionContainer", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "restoreCaretAndSelection"));
        }
        if (toMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toMove", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "restoreCaretAndSelection"));
        }
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        CaretModel caretModel = editor.getCaretModel();
        Integer selectionLen = selectionContainer.myLen;
        PsiElement at = file.findElementAt(offset);
        if (at != null) {
            PsiElement added = PyStatementMover.getCommentOrStatement(document, at);
            int size = toMove.size;
            if (size > 1) {
                for (PsiElement tmp = added.getNextSibling(); size > 1 && tmp != null; tmp = tmp.getNextSibling(), --size) {
                    if (!(tmp instanceof PsiWhiteSpace)) continue;
                    if (!selectionStartAtCaret) {
                        shift += tmp.getTextLength();
                    }
                    selectionLen = selectionLen + tmp.getTextLength();
                }
            }
            if (shift < 0) {
                shift = 0;
            }
            int column = editor.offsetToLogicalPosition((int)added.getTextRange().getStartOffset()).column;
            selectionLen = selectionContainer.myAtTheBeginning || column < selectionContainer.myAdditional ? Integer.valueOf(selectionLen + column) : Integer.valueOf(selectionLen + selectionContainer.myAdditional);
            if (selectionContainer.myAtTheBeginning && selectionStartAtCaret) {
                shift = -column;
            }
        }
        if ((newCaretOffset = offset + shift) >= (documentLength = document.getTextLength())) {
            newCaretOffset = documentLength;
        }
        caretModel.moveToOffset(newCaretOffset);
        if (hasSelection) {
            if (selectionStartAtCaret) {
                int newSelectionEnd = newCaretOffset + selectionLen;
                selectionModel.setSelection(newCaretOffset, newSelectionEnd);
            } else {
                int newSelectionStart = newCaretOffset - selectionLen;
                selectionModel.setSelection(newSelectionStart, newCaretOffset);
            }
        }
    }

    private static int getCaretShift(PsiElement startToMove, PsiElement endToMove, CaretModel caretModel, boolean selectionStartAtCaret) {
        int shift;
        if (selectionStartAtCaret) {
            shift = caretModel.getOffset() - startToMove.getTextRange().getStartOffset();
        } else {
            shift = caretModel.getOffset();
            if (startToMove != endToMove) {
                shift += startToMove.getTextLength();
                for (PsiElement tmp = startToMove.getNextSibling(); tmp != endToMove && tmp != null; tmp = tmp.getNextSibling()) {
                    if (tmp instanceof PsiWhiteSpace) continue;
                    shift += tmp.getTextLength();
                }
            }
            shift -= endToMove.getTextOffset();
        }
        return shift;
    }

    private static int moveTheSameLevel(@NotNull ScopeRange toMove2, @NotNull MyLineRange toMove) {
        if (toMove2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toMove2", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveTheSameLevel"));
        }
        if (toMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toMove", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveTheSameLevel"));
        }
        PsiElement anchor = toMove2.getAnchor();
        PsiElement anchorCopy = anchor.copy();
        PsiElement startToMove = toMove.myStartElement;
        PsiElement endToMove = toMove.myEndElement;
        PsiElement parent = anchor.getParent();
        PsiElement tmp = startToMove.getNextSibling();
        if (startToMove != endToMove && tmp != null) {
            parent.addRangeAfter(tmp, endToMove, anchor);
        }
        PsiElement startCopy = startToMove.copy();
        startToMove.replace(anchorCopy);
        PsiElement addedElement = anchor.replace(startCopy);
        if (startToMove != endToMove && tmp != null) {
            parent.deleteChildRange(tmp, endToMove);
        }
        return addedElement.getTextRange().getStartOffset();
    }

    private static int moveInOut(@NotNull MyLineRange toMove, final @NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info) {
        PsiElement psiElement;
        PsiElement addedElement;
        PyStatement[] statements;
        if (toMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toMove", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveInOut"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveInOut"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "moveInOut"));
        }
        boolean removePass = false;
        ScopeRange toMove2 = (ScopeRange)info.toMove2;
        PsiElement scope = toMove2.getScope();
        final PsiElement anchor = toMove2.getAnchor();
        Project project = scope.getProject();
        final PsiElement startElement = toMove.myStartElement;
        PsiElement endElement = toMove.myEndElement;
        PsiElement parent = startElement.getParent();
        if (scope instanceof PyStatementList && (startElement != endElement || !(startElement instanceof PsiComment)) && (statements = ((PyStatementList)scope).getStatements()).length == 1 && statements[0] == anchor && statements[0] instanceof PyPassStatement) {
            removePass = true;
        }
        PsiElement nextSibling = startElement.getNextSibling();
        if (toMove2.isAddBefore()) {
            PsiElement tmp = endElement.getPrevSibling();
            if (startElement != endElement && tmp != null) {
                addedElement = scope.addRangeBefore(startElement, tmp, anchor);
                scope.addBefore(endElement, anchor);
            } else {
                addedElement = scope.addBefore(endElement, anchor);
            }
        } else {
            if (startElement != endElement && nextSibling != null) {
                scope.addRangeAfter(nextSibling, endElement, anchor);
            }
            addedElement = scope.addAfter(startElement, anchor);
        }
        PyStatementMover.addPassStatement(toMove, project);
        if (startElement != endElement && nextSibling != null) {
            parent.deleteChildRange(nextSibling, endElement);
        }
        startElement.delete();
        int addedElementLine = editor.getDocument().getLineNumber(addedElement.getTextOffset());
        PsiFile file = scope.getContainingFile();
        PyStatementMover.adjustLineIndents(editor, scope, project, addedElement, toMove.size);
        if (removePass) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    Document document = editor.getDocument();
                    int lineNumber = document.getLineNumber(anchor.getTextOffset());
                    int endOffset = document.getLineCount() <= lineNumber + 1 ? document.getLineEndOffset(lineNumber) : document.getLineStartOffset(lineNumber + 1);
                    document.deleteString(document.getLineStartOffset(lineNumber), endOffset);
                    PsiDocumentManager.getInstance((Project)startElement.getProject()).commitAllDocuments();
                }
            });
        }
        int offset = addedElement.getTextRange().getStartOffset();
        int newLine = editor.getDocument().getLineNumber(offset);
        if (newLine != addedElementLine && !removePass && (psiElement = PyUtil.findNonWhitespaceAtOffset(file, editor.getDocument().getLineEndOffset(addedElementLine) - 1)) != null) {
            psiElement = PyStatementMover.getCommentOrStatement(editor.getDocument(), psiElement);
            offset = psiElement.getTextRange().getStartOffset();
        }
        return offset;
    }

    private static void adjustLineIndents(@NotNull Editor editor, @NotNull PsiElement scope, @NotNull Project project, @NotNull PsiElement addedElement, int size) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "adjustLineIndents"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "adjustLineIndents"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "adjustLineIndents"));
        }
        if (addedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "addedElement", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "adjustLineIndents"));
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        Document document = editor.getDocument();
        if (!(scope instanceof PsiFile)) {
            int line1 = editor.offsetToLogicalPosition((int)scope.getTextRange().getStartOffset()).line;
            int line2 = editor.offsetToLogicalPosition((int)scope.getTextRange().getEndOffset()).line;
            codeStyleManager.adjustLineIndent(scope.getContainingFile(), new TextRange(document.getLineStartOffset(line1), document.getLineEndOffset(line2)));
        } else {
            PsiElement tmp;
            int line1 = editor.offsetToLogicalPosition((int)addedElement.getTextRange().getStartOffset()).line;
            PsiElement end = addedElement;
            while (size > 0 && (tmp = end.getNextSibling()) != null) {
                --size;
                end = tmp;
            }
            int endOffset = end.getTextRange().getEndOffset();
            int line2 = editor.offsetToLogicalPosition((int)endOffset).line;
            codeStyleManager.adjustLineIndent(scope.getContainingFile(), new TextRange(document.getLineStartOffset(line1), document.getLineEndOffset(line2)));
        }
    }

    private static void addPassStatement(@NotNull MyLineRange toMove, @NotNull Project project) {
        if (toMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toMove", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "addPassStatement"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover", "addPassStatement"));
        }
        PsiElement startElement = toMove.myStartElement;
        PsiElement endElement = toMove.myEndElement;
        PyStatementList initialScope = PyStatementMover.getStatementList(startElement);
        if (!(initialScope == null || startElement == endElement && startElement instanceof PsiComment || initialScope.getStatements().length != toMove.statementsSize)) {
            PyPassStatement passStatement = PyElementGenerator.getInstance(project).createPassStatement();
            initialScope.addAfter((PsiElement)passStatement, (PsiElement)initialScope.getStatements()[initialScope.getStatements().length - 1]);
        }
    }

    static class ScopeRange
    extends LineRange {
        private PsiElement myScope;
        @NotNull
        private PsiElement myAnchor;
        private boolean addBefore;
        private boolean theSameLevel;

        public ScopeRange(@NotNull PsiElement scope, @NotNull PsiElement anchor, boolean before) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover$ScopeRange", "<init>"));
            }
            if (anchor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover$ScopeRange", "<init>"));
            }
            super(scope);
            this.myScope = scope;
            this.myAnchor = anchor;
            this.addBefore = before;
        }

        public ScopeRange(PyElement scope, @NotNull PsiElement anchor, boolean before, boolean b) {
            if (anchor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover$ScopeRange", "<init>"));
            }
            super((PsiElement)scope);
            this.myScope = scope;
            this.myAnchor = anchor;
            this.addBefore = before;
            this.theSameLevel = b;
        }

        @NotNull
        public PsiElement getAnchor() {
            PsiElement psiElement = this.myAnchor;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover$ScopeRange", "getAnchor"));
            }
            return psiElement;
        }

        public PsiElement getScope() {
            return this.myScope;
        }

        public boolean isAddBefore() {
            return this.addBefore;
        }

        public boolean isTheSameLevel() {
            return this.theSameLevel;
        }
    }

    static class SelectionContainer {
        private int myLen;
        private int myAdditional;
        private boolean myAtTheBeginning;

        public SelectionContainer(int len, int additional, boolean atTheBeginning) {
            this.myLen = len;
            this.myAdditional = additional;
            this.myAtTheBeginning = atTheBeginning;
        }
    }

    static class MyLineRange
    extends LineRange {
        private PsiElement myStartElement;
        private PsiElement myEndElement;
        int size;
        int statementsSize;

        public MyLineRange(@NotNull PsiElement start, PsiElement end) {
            if (start == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/jetbrains/python/codeInsight/editorActions/moveUpDown/PyStatementMover$MyLineRange", "<init>"));
            }
            super(start, end);
            this.size = 0;
            this.statementsSize = 0;
            this.myStartElement = start;
            this.myEndElement = end;
            if (this.myStartElement == this.myEndElement) {
                this.size = 1;
                this.statementsSize = 1;
            } else {
                PsiElement counter;
                for (counter = this.myStartElement; counter != this.myEndElement && counter != null; counter = counter.getNextSibling()) {
                    ++this.size;
                    if (counter instanceof PsiWhiteSpace || counter instanceof PsiComment) continue;
                    ++this.statementsSize;
                }
                ++this.size;
                if (!(counter instanceof PsiWhiteSpace) && !(counter instanceof PsiComment)) {
                    ++this.statementsSize;
                }
            }
        }
    }
}

