/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.dataflow.scope.impl;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.dataflow.DFALimitExceededException;
import com.intellij.codeInsight.dataflow.map.DFAMap;
import com.intellij.codeInsight.dataflow.map.DFAMapEngine;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.PyReachingDefsDfaInstance;
import com.jetbrains.python.codeInsight.dataflow.PyReachingDefsSemilattice;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeVariable;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementNavigator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeImpl
implements Scope {
    private volatile Instruction[] myFlow;
    private volatile List<DFAMap<ScopeVariable>> myCachedScopeVariables;
    private volatile Set<String> myGlobals;
    private volatile Set<String> myNonlocals;
    private volatile List<Scope> myNestedScopes;
    private final ScopeOwner myFlowOwner;
    private volatile Map<String, PsiNamedElement> myNamedElements;
    private volatile List<PyImportedNameDefiner> myImportedNameDefiners;
    private volatile Set<String> myAugAssignments;
    private List<PyTargetExpression> myTargetExpressions;

    public ScopeImpl(ScopeOwner flowOwner) {
        this.myFlowOwner = flowOwner;
    }

    private synchronized void computeFlow() {
        if (this.myFlow == null) {
            this.myFlow = ControlFlowCache.getControlFlow(this.myFlowOwner).getInstructions();
        }
    }

    @Override
    public ScopeVariable getDeclaredVariable(@NotNull PsiElement anchorElement, @NotNull String name) throws DFALimitExceededException {
        if (anchorElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchorElement", "com/jetbrains/python/codeInsight/dataflow/scope/impl/ScopeImpl", "getDeclaredVariable"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/dataflow/scope/impl/ScopeImpl", "getDeclaredVariable"));
        }
        this.computeScopeVariables();
        for (int i = 0; i < this.myFlow.length; ++i) {
            Instruction instruction = this.myFlow[i];
            PsiElement element = instruction.getElement();
            if (element != anchorElement) continue;
            return this.myCachedScopeVariables.get(i).get(name);
        }
        return null;
    }

    private synchronized void computeScopeVariables() throws DFALimitExceededException {
        this.computeFlow();
        if (this.myCachedScopeVariables == null) {
            PyReachingDefsDfaInstance dfaInstance = new PyReachingDefsDfaInstance();
            PyReachingDefsSemilattice semilattice = new PyReachingDefsSemilattice();
            DFAMapEngine<ScopeVariable> engine = new DFAMapEngine<ScopeVariable>(this.myFlow, dfaInstance, semilattice);
            this.myCachedScopeVariables = engine.performDFA();
        }
    }

    @Override
    public boolean isGlobal(String name) {
        if (this.myGlobals == null || this.myNestedScopes == null) {
            this.collectDeclarations();
        }
        if (this.myGlobals.contains(name)) {
            return true;
        }
        for (Scope scope : this.myNestedScopes) {
            if (!scope.isGlobal(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNonlocal(String name) {
        if (this.myNonlocals == null || this.myNestedScopes == null) {
            this.collectDeclarations();
        }
        return this.myNonlocals.contains(name);
    }

    private boolean isAugAssignment(String name) {
        if (this.myAugAssignments == null || this.myNestedScopes == null) {
            this.collectDeclarations();
        }
        return this.myAugAssignments.contains(name);
    }

    @Override
    public boolean containsDeclaration(String name) {
        if (this.myNamedElements == null || this.myImportedNameDefiners == null) {
            this.collectDeclarations();
        }
        if (this.isNonlocal(name)) {
            return false;
        }
        if (this.getNamedElement(name, true) != null) {
            return true;
        }
        if (this.isAugAssignment(name)) {
            return true;
        }
        for (PyImportedNameDefiner definer : this.getImportedNameDefiners()) {
            if (definer.getElementNamed(name) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<PyImportedNameDefiner> getImportedNameDefiners() {
        if (this.myImportedNameDefiners == null) {
            this.collectDeclarations();
        }
        List<PyImportedNameDefiner> list = this.myImportedNameDefiners;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/dataflow/scope/impl/ScopeImpl", "getImportedNameDefiners"));
        }
        return list;
    }

    @Override
    @Nullable
    public PsiNamedElement getNamedElement(String name, boolean includeNestedGlobals) {
        PsiNamedElement element;
        if (this.myNamedElements == null) {
            this.collectDeclarations();
        }
        if ((element = this.myNamedElements.get(name)) != null) {
            return element;
        }
        if (includeNestedGlobals && this.isGlobal(name)) {
            for (Scope scope : this.myNestedScopes) {
                PsiNamedElement global = scope.getNamedElement(name, true);
                if (global == null) continue;
                return global;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<PsiNamedElement> getNamedElements() {
        if (this.myNamedElements == null) {
            this.collectDeclarations();
        }
        Collection<PsiNamedElement> collection = this.myNamedElements.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/dataflow/scope/impl/ScopeImpl", "getNamedElements"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<PyTargetExpression> getTargetExpressions() {
        if (this.myTargetExpressions == null) {
            this.collectDeclarations();
        }
        List<PyTargetExpression> list = this.myTargetExpressions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/dataflow/scope/impl/ScopeImpl", "getTargetExpressions"));
        }
        return list;
    }

    private void collectDeclarations() {
        final HashMap<String, PsiNamedElement> namedElements = new HashMap<String, PsiNamedElement>();
        final ArrayList<PyImportedNameDefiner> importedNameDefiners = new ArrayList<PyImportedNameDefiner>();
        final ArrayList<Scope> nestedScopes = new ArrayList<Scope>();
        final HashSet<String> globals = new HashSet<String>();
        final HashSet<String> nonlocals = new HashSet<String>();
        final HashSet<String> augAssignments = new HashSet<String>();
        final ArrayList<PyTargetExpression> targetExpressions = new ArrayList<PyTargetExpression>();
        this.myFlowOwner.acceptChildren(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyTargetExpression(PyTargetExpression node) {
                targetExpressions.add(node);
                PsiElement parent = node.getParent();
                if (!node.isQualified() && !(parent instanceof PyImportElement)) {
                    super.visitPyTargetExpression(node);
                }
            }

            @Override
            public void visitPyReferenceExpression(PyReferenceExpression node) {
                if (PyAugAssignmentStatementNavigator.getStatementByTarget((PsiElement)node) != null) {
                    augAssignments.add(node.getName());
                }
                super.visitPyReferenceExpression(node);
            }

            @Override
            public void visitPyGlobalStatement(PyGlobalStatement node) {
                for (PyTargetExpression expression : node.getGlobals()) {
                    String name = expression.getReferencedName();
                    globals.add(name);
                    namedElements.put(name, expression);
                }
                super.visitPyGlobalStatement(node);
            }

            @Override
            public void visitPyNonlocalStatement(PyNonlocalStatement node) {
                for (PyTargetExpression expression : node.getVariables()) {
                    nonlocals.add(expression.getReferencedName());
                }
                super.visitPyNonlocalStatement(node);
            }

            @Override
            public void visitPyFunction(PyFunction node) {
                for (PyParameter parameter : node.getParameterList().getParameters()) {
                    PyExpression defaultValue = parameter.getDefaultValue();
                    if (defaultValue == null) continue;
                    defaultValue.accept(this);
                }
                super.visitPyFunction(node);
            }

            @Override
            public void visitPyElement(PyElement node) {
                if (node instanceof PsiNamedElement && !(node instanceof PyKeywordArgument)) {
                    namedElements.put(node.getName(), (PsiNamedElement)node);
                }
                if (node instanceof PyImportedNameDefiner) {
                    importedNameDefiners.add((PyImportedNameDefiner)node);
                }
                if (node instanceof ScopeOwner) {
                    Scope scope = ControlFlowCache.getScope((ScopeOwner)node);
                    nestedScopes.add(scope);
                } else {
                    super.visitPyElement(node);
                }
            }
        });
        Collections.reverse(importedNameDefiners);
        this.myNamedElements = namedElements;
        this.myImportedNameDefiners = importedNameDefiners;
        this.myNestedScopes = nestedScopes;
        this.myGlobals = globals;
        this.myNonlocals = nonlocals;
        this.myAugAssignments = augAssignments;
        this.myTargetExpressions = targetExpressions;
    }
}

