/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.dataflow.scope;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.impl.PyExceptPartNavigator;
import com.jetbrains.python.psi.impl.PyForStatementNavigator;
import com.jetbrains.python.psi.impl.PyListCompExpressionNavigator;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeUtil {
    private ScopeUtil() {
    }

    @Nullable
    public static PsiElement getParameterScope(PsiElement element) {
        PyFunction function;
        if (element instanceof PyNamedParameter && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false)) != null) {
            return function;
        }
        PyExceptPart exceptPart = PyExceptPartNavigator.getPyExceptPartByTarget(element);
        if (exceptPart != null) {
            return exceptPart;
        }
        PyForStatement forStatement = PyForStatementNavigator.getPyForStatementByIterable(element);
        if (forStatement != null) {
            return forStatement;
        }
        PyListCompExpression listCompExpression = PyListCompExpressionNavigator.getPyListCompExpressionByVariable(element);
        if (listCompExpression != null) {
            return listCompExpression;
        }
        return null;
    }

    @Nullable
    public static ScopeOwner getScopeOwner(@Nullable PsiElement element) {
        PyFunction function;
        PyAnnotation annotation;
        PyClass containingClass;
        StubElement stub;
        if (element instanceof StubBasedPsiElement && (stub = ((StubBasedPsiElement)element).getStub()) != null) {
            for (StubElement parentStub = stub.getParentStub(); parentStub != null; parentStub = parentStub.getParentStub()) {
                PsiElement parent = parentStub.getPsi();
                if (!(parent instanceof ScopeOwner)) continue;
                return (ScopeOwner)parent;
            }
            return null;
        }
        ScopeOwner firstOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)element, ScopeOwner.class);
        if (firstOwner == null) {
            return null;
        }
        ScopeOwner nextOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)firstOwner, ScopeOwner.class);
        PyElement decoratorAncestor = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, PyDecorator.class);
        if (decoratorAncestor != null && !PsiTreeUtil.isAncestor((PsiElement)decoratorAncestor, (PsiElement)firstOwner, (boolean)true)) {
            return nextOwner;
        }
        PyNamedParameter parameterAncestor = (PyNamedParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PyNamedParameter.class);
        if (parameterAncestor != null && !PsiTreeUtil.isAncestor((PsiElement)parameterAncestor, (PsiElement)firstOwner, (boolean)true)) {
            PyExpression defaultValue = parameterAncestor.getDefaultValue();
            PyAnnotation annotation2 = parameterAncestor.getAnnotation();
            if (PsiTreeUtil.isAncestor((PsiElement)defaultValue, (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)annotation2, (PsiElement)element, (boolean)false)) {
                return nextOwner;
            }
        }
        if ((containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class)) != null && PsiTreeUtil.isAncestor((PsiElement)containingClass.getSuperClassExpressionList(), (PsiElement)element, (boolean)false)) {
            return nextOwner;
        }
        if (firstOwner instanceof PyFunction && PsiTreeUtil.isAncestor((PsiElement)(annotation = (function = (PyFunction)firstOwner).getAnnotation()), (PsiElement)element, (boolean)false)) {
            return nextOwner;
        }
        return firstOwner;
    }

    @Nullable
    public static ScopeOwner getDeclarationScopeOwner(PsiElement anchor, String name) {
        PsiElement element = anchor;
        if (name != null) {
            ScopeOwner originalScopeOwner;
            ScopeOwner scopeOwner = originalScopeOwner = ScopeUtil.getScopeOwner(element);
            while (scopeOwner != null) {
                Scope scope;
                if ((!(scopeOwner instanceof PyClass) || scopeOwner == originalScopeOwner) && (scope = ControlFlowCache.getScope(scopeOwner)).containsDeclaration(name)) {
                    return scopeOwner;
                }
                scopeOwner = ScopeUtil.getScopeOwner((PsiElement)scopeOwner);
            }
        }
        return null;
    }

    @NotNull
    public static Collection<PsiElement> getReadWriteElements(@NotNull String name, @NotNull ScopeOwner scopeOwner, boolean isReadAccess, boolean isWriteAccess) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/dataflow/scope/ScopeUtil", "getReadWriteElements"));
        }
        if (scopeOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeOwner", "com/jetbrains/python/codeInsight/dataflow/scope/ScopeUtil", "getReadWriteElements"));
        }
        ControlFlow flow = ControlFlowCache.getControlFlow(scopeOwner);
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (Instruction instr : flow.getInstructions()) {
            ReadWriteInstruction rw;
            if (!(instr instanceof ReadWriteInstruction) || !name.equals((rw = (ReadWriteInstruction)instr).getName())) continue;
            ReadWriteInstruction.ACCESS access = rw.getAccess();
            if ((!isReadAccess || !access.isReadAccess()) && (!isWriteAccess || !access.isWriteAccess())) continue;
            result.add(rw.getElement());
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/dataflow/scope/ScopeUtil", "getReadWriteElements"));
        }
        return arrayList;
    }
}

