/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.dataflow;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.dataflow.map.DFAMap;
import com.intellij.codeInsight.dataflow.map.DfaMapInstance;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeVariable;
import com.jetbrains.python.codeInsight.dataflow.scope.impl.ScopeVariableImpl;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.impl.PyExceptPartNavigator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyReachingDefsDfaInstance
implements DfaMapInstance<ScopeVariable> {
    public static final DFAMap<ScopeVariable> INITIAL_MAP = new DFAMap();

    @Override
    public DFAMap<ScopeVariable> fun(DFAMap<ScopeVariable> map, Instruction instruction) {
        PsiElement element = instruction.getElement();
        if (element == null || !((PyFile)element.getContainingFile()).getLanguageLevel().isPy3K()) {
            return this.processReducedMap(map, instruction, element);
        }
        DFAMap<ScopeVariable> reducedMap = new DFAMap<ScopeVariable>();
        for (Map.Entry<String, ScopeVariable> entry : map.entrySet()) {
            PsiElement declaration;
            PyExceptPart exceptPart;
            ScopeVariable value = entry.getValue();
            if (value.isParameter() && (exceptPart = PyExceptPartNavigator.getPyExceptPartByTarget(declaration = value.getDeclarations().iterator().next())) != null && !PsiTreeUtil.isAncestor((PsiElement)exceptPart, (PsiElement)element, (boolean)false)) continue;
            reducedMap.put(entry.getKey(), value);
        }
        return this.processReducedMap(reducedMap, instruction, element);
    }

    private DFAMap<ScopeVariable> processReducedMap(DFAMap<ScopeVariable> map, Instruction instruction, PsiElement element) {
        String name = null;
        if (instruction instanceof ReadWriteInstruction && ((ReadWriteInstruction)instruction).getAccess().isWriteAccess()) {
            name = ((ReadWriteInstruction)instruction).getName();
        } else if (element instanceof PyFunction) {
            name = ((PyFunction)element).getName();
        }
        if (name == null) {
            return map;
        }
        ScopeVariable variable = map.get(name);
        PsiElement parameterScope = ScopeUtil.getParameterScope(element);
        if (parameterScope != null) {
            ScopeVariableImpl scopeVariable = new ScopeVariableImpl(name, true, element);
            map = map.asWritable();
            map.put(name, scopeVariable);
        } else {
            boolean isParameter = variable != null && variable.isParameter();
            ScopeVariableImpl scopeVariable = variable == null ? new ScopeVariableImpl(name, isParameter, element) : new ScopeVariableImpl(name, isParameter, variable.getDeclarations());
            map = map.asWritable();
            map.put(name, scopeVariable);
        }
        return map;
    }

    @Override
    @NotNull
    public DFAMap<ScopeVariable> initial() {
        DFAMap<ScopeVariable> dFAMap = INITIAL_MAP;
        if (dFAMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/dataflow/PyReachingDefsDfaInstance", "initial"));
        }
        return dFAMap;
    }

    @Override
    public boolean isForward() {
        return true;
    }
}

