/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.controlflow.InstructionTypeCallback;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;

public class PyTypeAssertionEvaluator
extends PyRecursiveElementVisitor {
    private Stack<Assertion> myStack = new Stack();
    private boolean myPositive;

    public PyTypeAssertionEvaluator() {
        this(true);
    }

    public PyTypeAssertionEvaluator(boolean positive) {
        this.myPositive = positive;
    }

    public List<Assertion> getDefinitions() {
        return this.myStack;
    }

    @Override
    public void visitPyPrefixExpression(PyPrefixExpression node) {
        if (node.getOperator() == PyTokenTypes.NOT_KEYWORD) {
            this.myPositive = !this.myPositive;
            super.visitPyPrefixExpression(node);
            this.myPositive = !this.myPositive;
        } else {
            super.visitPyPrefixExpression(node);
        }
    }

    @Override
    public void visitPyCallExpression(PyCallExpression node) {
        PyExpression[] args;
        if (node.isCalleeText("isinstance") || node.isCalleeText("assertIsInstance")) {
            PyExpression[] args2 = node.getArguments();
            if (args2.length == 2 && args2[0] instanceof PyReferenceExpression) {
                final PyReferenceExpression target = (PyReferenceExpression)args2[0];
                final PyExpression typeElement = args2[1];
                final boolean positive = this.myPositive;
                this.pushAssertion(target, new InstructionTypeCallback(){

                    @Override
                    public PyType getType(TypeEvalContext context, PsiElement anchor) {
                        ArrayList<PyType> types = new ArrayList<PyType>();
                        types.add(context.getType(typeElement));
                        return PyTypeAssertionEvaluator.createAssertionType(context.getType(target), types, positive, context);
                    }
                });
            }
        } else if (node.isCalleeText("callable") && (args = node.getArguments()).length == 1 && args[0] instanceof PyReferenceExpression) {
            final PyReferenceExpression target = (PyReferenceExpression)args[0];
            final boolean positive = this.myPositive;
            this.pushAssertion(target, new InstructionTypeCallback(){

                @Override
                public PyType getType(TypeEvalContext context, PsiElement anchor) {
                    ArrayList<PyType> types = new ArrayList<PyType>();
                    types.add(PyTypeParser.getTypeByName((PsiElement)target, "collections.Callable"));
                    return PyTypeAssertionEvaluator.createAssertionType(context.getType(target), types, positive, context);
                }
            });
        }
    }

    @Override
    public void visitPyReferenceExpression(final PyReferenceExpression node) {
        if (node.getParent() instanceof PyIfPart) {
            final boolean positive = this.myPositive;
            this.pushAssertion(node, new InstructionTypeCallback(){

                @Override
                public PyType getType(TypeEvalContext context, PsiElement anchor) {
                    ArrayList<PyNoneType> types = new ArrayList<PyNoneType>();
                    types.add(PyNoneType.INSTANCE);
                    return PyTypeAssertionEvaluator.createAssertionType(context.getType(node), types, !positive, context);
                }
            });
            return;
        }
        super.visitPyReferenceExpression(node);
    }

    @Override
    public void visitPyBinaryExpression(PyBinaryExpression node) {
        if (node.isOperator("isnot")) {
            PyExpression lhs = node.getLeftExpression();
            PyExpression rhs = node.getRightExpression();
            if (lhs instanceof PyReferenceExpression && rhs instanceof PyReferenceExpression) {
                final PyReferenceExpression target = (PyReferenceExpression)lhs;
                if ("None".equals(rhs.getName())) {
                    final boolean positive = this.myPositive;
                    this.pushAssertion(target, new InstructionTypeCallback(){

                        @Override
                        public PyType getType(TypeEvalContext context, @Nullable PsiElement anchor) {
                            ArrayList<PyNoneType> types = new ArrayList<PyNoneType>();
                            types.add(PyNoneType.INSTANCE);
                            return PyTypeAssertionEvaluator.createAssertionType(context.getType(target), types, !positive, context);
                        }
                    });
                    return;
                }
            }
        }
        super.visitPyBinaryExpression(node);
    }

    @Nullable
    private static PyType createAssertionType(PyType initial, List<PyType> types, boolean positive, TypeEvalContext context) {
        ArrayList<PyType> members = new ArrayList<PyType>();
        for (PyType t : types) {
            members.add(PyTypeAssertionEvaluator.transformTypeFromAssertion(t));
        }
        PyType union = PyUnionType.union(members);
        if (positive) {
            return union;
        }
        if (initial instanceof PyUnionType) {
            return ((PyUnionType)initial).exclude(union, context);
        }
        if (PyTypeChecker.match(union, initial, context)) {
            return null;
        }
        return initial;
    }

    @Nullable
    private static PyType transformTypeFromAssertion(@Nullable PyType type) {
        if (type instanceof PyTupleType) {
            ArrayList<PyType> members = new ArrayList<PyType>();
            PyTupleType tupleType = (PyTupleType)type;
            int count = tupleType.getElementCount();
            for (int i = 0; i < count; ++i) {
                members.add(PyTypeAssertionEvaluator.transformTypeFromAssertion(tupleType.getElementType(i)));
            }
            return PyUnionType.union(members);
        }
        if (type instanceof PyClassType) {
            return ((PyClassType)type).toInstance();
        }
        return type;
    }

    private void pushAssertion(PyReferenceExpression element, InstructionTypeCallback getType) {
        this.myStack.push(new Assertion(element, getType));
    }

    static class Assertion {
        private final PyReferenceExpression element;
        private InstructionTypeCallback myFunction;

        Assertion(PyReferenceExpression element, InstructionTypeCallback getType) {
            this.element = element;
            this.myFunction = getType;
        }

        public PyReferenceExpression getElement() {
            return this.element;
        }

        public InstructionTypeCallback getTypeEvalFunction() {
            return this.myFunction;
        }
    }
}

