/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.openapi.util.Key;
import com.intellij.reference.SoftReference;
import com.jetbrains.python.codeInsight.controlflow.PyControlFlowBuilder;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.impl.ScopeImpl;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;

public class ControlFlowCache {
    private static Key<SoftReference<ControlFlow>> CONTROL_FLOW_KEY = Key.create((String)"com.jetbrains.python.codeInsight.controlflow.ControlFlow");
    private static Key<SoftReference<Scope>> SCOPE_KEY = Key.create((String)"com.jetbrains.python.codeInsight.controlflow.Scope");

    private ControlFlowCache() {
    }

    public static void clear(ScopeOwner scopeOwner) {
        scopeOwner.putUserData(CONTROL_FLOW_KEY, null);
        scopeOwner.putUserData(SCOPE_KEY, null);
    }

    public static ControlFlow getControlFlow(@NotNull ScopeOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/controlflow/ControlFlowCache", "getControlFlow"));
        }
        SoftReference ref = (SoftReference)element.getUserData(CONTROL_FLOW_KEY);
        ControlFlow flow = (ControlFlow)SoftReference.dereference((Reference)ref);
        if (flow == null) {
            flow = new PyControlFlowBuilder().buildControlFlow(element);
            element.putUserData(CONTROL_FLOW_KEY, new SoftReference((Object)flow));
        }
        return flow;
    }

    @NotNull
    public static Scope getScope(@NotNull ScopeOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/controlflow/ControlFlowCache", "getScope"));
        }
        SoftReference ref = (SoftReference)element.getUserData(SCOPE_KEY);
        Scope scope = (Scope)SoftReference.dereference((Reference)ref);
        if (scope == null) {
            scope = new ScopeImpl(element);
            element.putUserData(SCOPE_KEY, new SoftReference((Object)scope));
        }
        Scope scope2 = scope;
        if (scope2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/controlflow/ControlFlowCache", "getScope"));
        }
        return scope2;
    }
}

