/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonLookupElement
extends LookupElement
implements Comparable<LookupElement> {
    protected final String myLookupString;
    protected final String myTypeText;
    protected final boolean isBold;
    protected final Icon myIcon;
    private final Icon myTypeIcon;
    protected final String myTailText;
    protected InsertHandler<PythonLookupElement> myHandler;

    public PythonLookupElement(@NotNull String lookupString, @Nullable String tailText, @Nullable String typeText, boolean bold, @Nullable Icon icon, @Nullable Icon typeIcon, @NotNull InsertHandler<PythonLookupElement> handler) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupString", "com/jetbrains/python/codeInsight/completion/PythonLookupElement", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/jetbrains/python/codeInsight/completion/PythonLookupElement", "<init>"));
        }
        this.myLookupString = lookupString;
        this.myTailText = tailText;
        this.myTypeText = typeText;
        this.isBold = bold;
        this.myIcon = icon;
        this.myTypeIcon = typeIcon;
        this.myHandler = handler;
    }

    public PythonLookupElement(@NotNull String lookupString, @Nullable String tailText, @Nullable String typeText, boolean bold, @Nullable Icon icon, @Nullable Icon typeIcon) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupString", "com/jetbrains/python/codeInsight/completion/PythonLookupElement", "<init>"));
        }
        this(lookupString, tailText, typeText, bold, icon, typeIcon, new BasicInsertHandler<PythonLookupElement>());
    }

    public PythonLookupElement(@NotNull String lookupString, boolean bold, @Nullable Icon icon) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupString", "com/jetbrains/python/codeInsight/completion/PythonLookupElement", "<init>"));
        }
        this(lookupString, null, null, bold, icon, null, new BasicInsertHandler<PythonLookupElement>());
    }

    @NotNull
    public String getLookupString() {
        String string = this.myLookupString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/completion/PythonLookupElement", "getLookupString"));
        }
        return string;
    }

    @Nullable
    public String getTailText() {
        return !StringUtil.isEmpty((String)this.myTailText) ? this.myTailText : null;
    }

    @Nullable
    protected String getTypeText() {
        return !StringUtil.isEmpty((String)this.myTypeText) ? this.myTypeText : null;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public Icon getTypeIcon() {
        return this.myTypeIcon;
    }

    public void handleInsert(InsertionContext context) {
        this.myHandler.handleInsert(context, (LookupElement)this);
    }

    public void setHandler(InsertHandler<PythonLookupElement> handler) {
        this.myHandler = handler;
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setItemText(this.getLookupString());
        presentation.setItemTextBold(this.isBold);
        presentation.setTailText(this.getTailText());
        presentation.setTypeText(this.getTypeText(), this.getTypeIcon());
        presentation.setIcon(this.getIcon());
    }

    @Override
    public int compareTo(LookupElement o) {
        return this.myLookupString.compareTo(o.getLookupString());
    }
}

