/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PySuperMethodCompletionContributor
extends CompletionContributor {
    public PySuperMethodCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespace(), (ElementPattern)PlatformPatterns.psiElement().withElementType((IElementType)PyTokenTypes.DEF_KEYWORD)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/codeInsight/completion/PySuperMethodCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/completion/PySuperMethodCompletionContributor$1", "addCompletions"));
                }
                PsiElement position = parameters.getOriginalPosition();
                PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)position, PyClass.class);
                if (containingClass == null && position instanceof PsiWhiteSpace) {
                    position = PsiTreeUtil.prevLeaf((PsiElement)position);
                    containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)position, PyClass.class);
                }
                if (containingClass == null) {
                    return;
                }
                HashSet<String> seenNames = new HashSet<String>();
                for (PyFunction function : containingClass.getMethods(false)) {
                    seenNames.add(function.getName());
                }
                LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)parameters.getOriginalFile());
                seenNames.addAll((Collection<String>)PyNames.getBuiltinMethods(languageLevel).keySet());
                for (PyClass ancestor : containingClass.getAncestorClasses()) {
                    for (PyFunction superMethod : ancestor.getMethods(false)) {
                        if (seenNames.contains(superMethod.getName())) continue;
                        String text = superMethod.getName() + superMethod.getParameterList().getText();
                        LookupElementBuilder element = LookupElementBuilder.create((String)text);
                        result.addElement(TailTypeDecorator.withTail(element, TailType.CASE_COLON));
                        seenNames.add(superMethod.getName());
                    }
                }
            }
        });
    }
}

